/* demonstrates dynamic overflow on heap (initialized data) */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#define ERROR -1
#define BUFSIZE 16

int main(int argc, char **argv)
{
   u_long diff;
   u_int oversize;
   register int i;

   char *buf1 = (char *)malloc(BUFSIZE), *buf2 = (char *)malloc(BUFSIZE);

   if (argc <= 1)
   {
      fprintf(stderr, "Usage: %s <numbytes>\n", argv[0]);
      fprintf(stderr, "[Will overflow dynamic buffer by <numbytes>]\n");
       
      exit(ERROR);
   }

   diff = (u_long)buf2 - (u_long)buf1;
   printf("buf1 = %p, buf2 = %p, diff = 0x%x bytes\n", buf1, buf2, diff);

   memset(buf2, 'A', BUFSIZE-1);
   buf2[BUFSIZE-1] = '\0';

   printf("before overflow: buf2 = %s\n", buf2);

   oversize = (u_int)(diff + atoi(argv[1]));
   memset(buf1, 'B', oversize);

   printf("after overflow: buf2 = %s\n", buf2);
   return 0;
}
