/* demonstrates static overflow in bss (uninitialized data) */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#define ERROR -1
#define BUFSIZE 16

int main(int argc, char **argv)
{
   u_long diff;

   int oversize;
   static char buf1[BUFSIZE], buf2[BUFSIZE];

   if (argc <= 1)
   {
      fprintf(stderr, "Usage: %s <numbytes>\n", argv[0]);
      fprintf(stderr, "[Will overflow static buffer by <numbytes>]\n");

      exit(ERROR);
   }

   diff = (u_long)buf2 - (u_long)buf1;

   printf("buf1 = %p, buf2 = %p, diff = 0x%x (%d) bytes\n\n", 
          buf1, buf2, diff, diff);

   memset(buf2, 'A', BUFSIZE - 1), memset(buf1, 'B', BUFSIZE - 1);
   buf1[BUFSIZE - 1] = '\0', buf2[BUFSIZE - 1] = '\0';

   printf("before overflow: buf1 = %s, buf2 = %s\n", buf1, buf2);

   oversize = diff + atoi(argv[1]);
   memset(buf1, 'B', oversize);

   buf1[BUFSIZE - 1] = '\0', buf2[BUFSIZE - 1] = '\0';
   printf("after overflow: buf1 = %s, buf2 = %s\n\n", buf1, buf2);

   return 0;
}
