/* demonstrates static pointer overflow in bss (uninitialized data) */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#define BUFSIZE 16
#define ADDRLEN 4 /* # of bytes in an address */

int main(int argc, char **argv)
{
   u_long diff;
   static char buf[BUFSIZE], *bufptr;

   bufptr = buf;
   diff = (u_long)&bufptr - (u_long)buf;

   printf("bufptr (%p) = %p, buf = %p, diff = 0x%x (%d) bytes\n",
           &bufptr, bufptr, buf, diff, diff);


   memset(buf, 'A', (u_int)(diff + ADDRLEN));

   printf("bufptr (%p) = %p, buf = %p, diff = 0x%x (%d) bytes\n",
           &bufptr, bufptr, buf, diff, diff);

   return 0;
}
