/* 
 * This is modified ASCII generator out of l0phtcrack
 * 
 * Usage: asciigen <startlen> <endlen> <type> [outfile]
 *
 * Description: Will generate all words of 'type' (alpha, alphanum, num,
 * sym or all) between 'startlen' and 'endlen' characters, outputting
 * the results to 'outfile' (or the terminal if unspecified)
 *
 * E.g., asciigen 3 5 alpha would go aaa-ZZZZZ
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define MAXPASSLEN 12

char num[] = "0123456789";
char sym[] = "~!@#$%^&*()_+`-=':;/.,?><\"\\";
char alpha[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

FILE *outfile;

char *buf;
int startlen, endlen;

void parseArgs(int argc, char **argv);

int main(int argc, char **argv)
{
   int buflen;
   register int i;
   char tmpbuf[128], *tmp_ptrs[MAXPASSLEN+1];

   memset(tmpbuf, 0, sizeof(tmpbuf));

   parseArgs(argc, argv);
   buflen = strlen(buf);

   for (i = 1; i <= endlen; i++) tmp_ptrs[i] = NULL;
   for (i = 0; i < startlen; i++) tmp_ptrs[i] = &buf[0];

   while(!tmp_ptrs[endlen]) 
   {
      for (i = 0; i < endlen; i++) 
      {
         if (tmp_ptrs[i] != 0) tmpbuf[i] = *tmp_ptrs[i];
         else break;
      }

      if (outfile) fprintf(outfile, "%s\n", tmpbuf);
      else printf("%s\n", tmpbuf); 

      tmp_ptrs[0]++;

      for (i = 0; i < endlen; i++)
      {
         if (tmp_ptrs[i] > &buf[buflen - 1]) 
         {
            tmp_ptrs[i] = &buf[0];

            if (tmp_ptrs[i+1] != 0) tmp_ptrs[i+1]++;
            else tmp_ptrs[i+1] = &buf[0];
         } 
      }
   }

   free(buf), fclose(outfile);
   return(0);
}

void parseArgs(int argc, char **argv)
{
   if ((argc < 4) || (argc > 5))
   {
      fprintf(stderr, "Usage: %s <startlen> <endlen> <type> [outfile]\n\n",
              argv[0]);

      fprintf(stderr, "Description: Will generate all words of 'type' "
              "(alpha, alphanum, num,\nsym or all) between 'startlen' "
              "and 'endlen' characters, outputting the\nresults to "
              "'outfile' (or the terminal if unspecified)\n\n");

      fprintf(stderr, "E.g., %s 3 5 alpha will do aaa-ZZZZZ\n", argv[0]);

      exit(1);
   }

   startlen = atoi(argv[1]);
   endlen = atoi(argv[2]);

   if (argc == 5)
   {
      outfile = fopen(argv[4], "a");
      if (!outfile)
      {
         fprintf(stderr, "Error fopen()'ing %s: %s\n", argv[4],
                 strerror(errno));

         exit(-1);
      }
   }

   if (strncmp(argv[3], "alphanum", 8) == 0)
   {
      buf = malloc(strlen(alpha) + strlen(num) + 1);
      sprintf(buf, "%s%s", alpha, num);
   }

   else if (strncmp(argv[3], "alpha", 5) == 0)
   {
      buf = malloc(strlen(alpha) + 1);
      strcpy(buf, alpha);
   }

   else if (strncmp(argv[3], "num", 3) == 0)
   {
      buf = malloc(strlen(num) + 1);
      strcpy(buf, num);
   }

   else if (strncmp(argv[3], "sym", 3) == 0)
   {
      buf = malloc(strlen(sym) + 1);
      strcpy(buf, sym);
   }

   else
   {
      buf = malloc(strlen(alpha) + strlen(num) + strlen(sym) + 1);
      sprintf(buf, "%s%s%s", alpha, num, sym);
   }
}
