/*
 * ParseWL v1.0 By: Interrupt <mike@datasurge.net>
 *  
 * This is a quick hack and I think the code pretty much 
 * sucks, although it works.  Heh.
 * 
 * Usage: parsewl <wordlist> <startlen> <endlen> [outfile]
 * Description: It will read words from 'wordlist', keeping only words
 * between 'startlen' and 'endlen' letters long, outputting the results to
 * 'outfile' (or terminal if unspecified).
 *
 * Use -DWINDOWS for Windows support, otherwise defaults to Unix systems.
 *
 * Benchmark stats:
 * P250MMX running Debian 2.1. parsed 155mb wordlist containing 12.8 million 
 * words to only words with 4 to 8 characters in 1.25 minutes.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#ifdef WINDOWS
#include <windows.h>
#endif

void usage (char *arg);

int main (int argc, char **argv)
{
   char word[100];
   int wordlen, large;
   FILE *wordlist, *sortedlist = NULL;

   if (argc < 4) usage (argv[0]);

   wordlist = fopen (argv[1], "r");
   if (!wordlist)
   {
      fprintf (stderr, "Error fopen()'ing %s: %s\n", argv[1], 
               strerror(errno));

      exit (-1);
   }

   if (argv[4])
   {
      sortedlist = fopen (argv[4], "a");
      if (!sortedlist)
      {
         fprintf(stderr, "Error fopen()'ing %s: %s\n", argv[4],
                 strerror(errno));

         fclose(wordlist), exit(-1);
      }
   }

   while (1)
   {
      if (!fgets (word, sizeof (word) - 1, wordlist))
      {
         if (feof (wordlist)) break;
         fclose (wordlist), exit (-1);
      }

      /* Get word length and keep only the "good" ones. */

      wordlen = strlen (word);

      large = atoi (argv[3]);
      if (strcspn (word, "\r\n")) large++; /* Have to do this for Windows. */

      if ((wordlen >= atoi (argv[2])) && (wordlen <= (large)))
      {
         if (sortedlist) fputs (word, sortedlist);
         else printf (word);
      }
   }

   fclose (sortedlist), fclose (wordlist);
   return 0;
}

void usage (char *arg)
{

  printf ("ParseWL v1.0 By: Interrupt <mike@datasurge.net>\n");
  printf ("Usage: %s <wordlist> <startlen> <endlen> [outfile]\n\n", arg);
  printf ("Description: Parses 'wordlist' and keeps words between "
          "'startlen' and\n'endlen' letters long, outputting the "
          "results to 'outfile' (or terminal\nif unspecified).\n\n");

  printf ("E.g., %s dictonary.txt 4 8 sortedfile.txt\n", arg);
  exit (1);
}
