#include <stdio.h>
#include <time.h>
#include <signal.h>
#include "colors.h"

#define TIME 100000

void sighandler(int signum);

void main()
{
  char buf[15];
  char space[40];
  int i;

  bzero(buf,   sizeof(buf));
  bzero(space, sizeof(space));

  sprintf(space, " ");
  sprintf(buf, "%sS %sH %sO %sK %sD %sI %sA %sL", 
	  PINK, BOLDCYAN, BOLDGREEN, BOLDRED,
	  BOLDBLUE, BOLDRED, BOLDGREEN, BOLDCYAN);

  signal(SIGALRM, sighandler);
  signal(SIGINT,  sighandler);
  signal(SIGQUIT, sighandler);
  signal(SIGTSTP, sighandler);

  alarm(5);
  for (i = 0; i < 28; i++) {
     if (i == 27) {
        printf("%sw00w00!\n", NORMAL);
        exit(0);
     }
     printf("%s%s\r", space, buf);
     fflush(stdout);
     usleep(TIME);
     strncat(space, " ", sizeof(space));
  }
  alarm(0);

  printf("%sw00w00!\n", NORMAL);
}

void sighandler(int signum)
{
  printf("%s", NORMAL);
  printf("w00w00!\n");
  exit(0);
}
