/*	  		     ShokDial                                   */
/*   w00w00!                                                            */
/*   This is (I have never seen one anyway, I apologize if I'm wrong)   */
/*   the first war dialer that I've ever seen for unix. This will       */
/*   compile on most/all unix operating systems.                        */
/*									*/
/* 	       Shok (Matt Conover), shok@dataforce.net                  */


#include <time.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>

#include "colors.h"

#define ERROR -1
#define LOGFILE "wardial.log" /* 
			       * Used as the default logfile,       
                               * unless you change this define      
                               * or specify it as an option.
                               * Type: shokdial -h for help.
			       */ 
				

#define VERSION "v4.1"
#define TIMEOUT 25     /* 
			* YOU WANT TO CONFIGURE THIS!!!
                        * This is how long it will wait until it
                        * gives up (or connects, whichever comes first
			*/

/* You can do:
 * ln -s /dev/cua1 /dev/modem
 * or change this  to /dev/cua1 (or whatever your COM is)
 * cua0 = COM1 cua1 = COM2
 * (in linux)...in IRIX this would be /dev/ttymX I believe
 */

#define MODEMPORT "/dev/modem"


/* 			Global variables			      */
/* 			----------------			      */
int  fd;                /* fd for modem      			      */
int  rand;	        /* Use random scanning if this is set         */
int  send;              /* Do we send a string to the carrier?        */
int  daemon;            /* Do we fork into the background?            */
int  listen;            /* Do we check a response from the carrier?   */
int  useStdin;          /* Do we read numbers from stdin?             */
int  numbytes;          /* To verify that all the bytes were written  */

int  First3Digits;      /* Such as "555" of 555-XXXX 	              */
                        /* However, this also serves as the area code */
                        /* for a long distance number                 */

int  First3Digits1;     /* This allows multiple ranges such as        */
                        /* 555-XXXX through 556-XXXX                  */

int  Last3Digits;       /* Used as XXX-555-XXXX                       */
int  Last3Digits1;      /* Same purpose as First3Digits1              */
int  ScanMin;           /* Number to scan from....like 0000 and up    */
int  ScanMin1;          /* Where to hold ScanMin the whole time       */
int  ScanMax;           /* Stop scanning when this number is reached  */
int  response;          /* Used to test if response timed out         */
char *LogFile;          /* Where to log connections 		      */
char buf[2048];	        /* Buffer for strings returned by modem       */
char pnum[512];         /* This is the phone number from config file  */
char LocalOrLong;       /* Dialing long distance of local 	      */
char sendstring[512];   /* Send to string to carrier (if send is set) */

char *ProgName;	  

int  noshow;            /* Don't display opening port when reopening  */
int  conf;              /* Dial using config file                     */
int  noOK;              /* Used with hanging up and checking "OK"     */
      
volatile int sig;           /* Set after signal received and finished */
volatile int connected = 0; /* Set to 1 when connected.               */

/* Some statistics.  */
int busy       = 0;
int connect    = 0;
int noresponse = 0;

/* 			Function prototypes		 	      */ 
/* 			------------------- 			      */
void usage();		      /*  Help/usage			      */
void version();               /*  Display version                     */
void intro(); 	              /*  An introduction		      */
void daemonize_me(); 	      /*  Fork into the background            */
void get_scanrange();         /*  Get the scanning range              */
void open_port();             /*  Open modem port for dialing	      */
void init_modem();            /*  Initialize the modem		      */
void dial_number();	      /*  Dial the number		      */
void inputdial();             /*  Read numbers from stdin             */
void confdial(char *confile); /*  For reading/dialing from conf file  */
void hangup();                /*  Hang up modem.                      */
void menu(int signum);        /*  Called when an abort is received.   */
void sighandler(int signum);  /*  Used when signals are received      */
void sighandler1(int signum); /*  Ditto                               */
void stopnow(int signum);     /*  Called from sig handler for an un-  */
                              /*  conditional exit.                   */

/* Function prototypes in other source files: */
/* ------------------------------------------ */
/* Check read/write/opens for errors  */
void check_for_error(char *LogFile, int fd, int num, char *s);

/* Check for "OK" from modem in reads. */
int checkok(char *LogFile, int fd, char *buf, char *s);
 
/* Check if the phone num was valid. */ 
void local_validnum(int digits);
void long_validnum(int firstdigits, int lastdigits);

/* Check to make sure they didn't pass conflicting options. */
void checkoptions();

/* Other miscellaneous prototypes included to avoid. */
int  clr();
void strip();

int main(int argc, char **argv)
{
  int  opt;
  char *confile;

  clr(); /* Clear the screen. */

  /* Do some stuff with the arguments                      */
  /* ----------------------------------------------------- */

  ProgName = argv[0];

  if (argc > 1) {
      while ((opt = getopt (argc, argv, "SsrdvhL:lc:")) != ERROR)
 	   switch(opt)
	   {
		case 'S':
		    useStdin = 1;
		    break;

                case 's':
		    send = 1;
		    break;

		case 'r':
	 	    rand = 1;
	     	    break;
			
                case 'd':
		    daemon = 1;
                    break;

		case 'v': 
		    version();

		case 'h':
		    usage();

		case 'L':
		    LogFile = optarg;
		    break;
		    
                case 'l':
		    listen = 1;
		    break;

		case 'c':
		    conf = 1;
		    confile = optarg;
		    break;

		case '?':
		    putchar('\n');
		    usage();

		default:
		    usage();
	  }
  }

  /* Check to make sure they didn't pass conflicting options. */  
  checkoptions(); /* exit()'s if there is an error */

  if (conf != 1 && useStdin != 1) 
     printf("\"%s-r%s\" (%srandom scanning%s) option not given, using %ssequential scanning%s instead.\n", 
 	    PINK, NORMAL, BOLDWHITE, NORMAL, BOLDRED, NORMAL);

  if (LogFile == NULL) {
     LogFile = LOGFILE;
     printf("Using \"%s%s%s\" as log file.\n", BOLDGREEN, LogFile, NORMAL);
  }

  printf("\nHit any key to continue...");
  getchar();

/* ----------------------------------------------------- */

  clr(); /* Clear the screen. */
  intro();

  clr(); /* Clear the screen. */
  if (conf != 1 && useStdin != 1) get_scanrange();


  /* We don't want to handle any signals until here */
  signal(SIGINT,  menu);
  signal(SIGTERM, menu);
  signal(SIGHUP,  SIG_IGN);
  signal(SIGALRM, sighandler1);

  if (daemon == 1) 
     daemonize_me();      /* Run the program in the background           */

  open_port();            /* Open MODEMPORT (by default /dev/cua1)       */
  init_modem();           /* Initialize modem (such as sending ATZ)      */

  if (send == 1) {
     printf("Enter string to send to carrier (when connected): ");
     scanf("%512s", sendstring);
  }

  /* What type of dialing are we using? */
  if (conf == 1)
     confdial(confile);   /* Read numbers to dial from a config file     */

  else if (useStdin == 1)
     inputdial();         /* Read numbers from stdin		         */

  else dial_number();     /* Do the scanning (used by default, instead   */
                          /* of confdial(), inputdial(), etc.)           */

  /* ---------------------------------- */

  hangup();               /* Hang up the modem			         */
  close(fd);              /* Close the open file descriptor of the modem */

  return 0;
}

/* -------------------------------------------------- */

void version()
{
  printf("This is %sS%sh%so%sk%sD%si%sa%sl %s%s%s...please keep notice of this.\n", 
	  BOLDCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, BOLDWHITE,
          BOLDRED, PINK, BOLDBLUE, VERSION, NORMAL);

  printf("in case this program under goes some new features, fixes, etc.\n\n");

  printf("\t\t\t%s Shok %s\n\t\t    (%sMatt Conover%s)\n\n", 
	  BOLDBLUE, NORMAL, BOLDWHITE, NORMAL);

  printf("%sEmail%s: %sshok@dataforce.net%s\n",
         BOLDWHITE, NORMAL, PINK, NORMAL);

  printf("%sWWW%s: %shttp://www.w00w00.org/%s\n",
         BOLDWHITE, NORMAL, PINK, NORMAL);


  exit(0);
}

/* -------------------------------------------------- */

void usage()
{
  printf("Usage: %s%s %s[-rhvdSsl]%s -c [config file]%s -L [logfile]%s\n\n", PINK, ProgName, BOLDWHITE, BOLDCYAN, BOLDGREEN, NORMAL);
  printf("Options:\n");
  printf("%s-r%s for %srandom%s (as opposed to %ssequential%s) scanning\n", BOLDCYAN, NORMAL, PINK, NORMAL, YELLOW, NORMAL);
  printf("%s-h%s for %shelp%s....what you're seeing now\n", PINK, NORMAL, BOLDRED, NORMAL);
  printf("%s-v%s for the %sversion%s...because this will probably undergo changes\n", BOLDGREEN, NORMAL, BOLDCYAN, NORMAL);
  printf("%s-d%s to run in the %sbackground%s.\n", BLUE, NORMAL, BOLDGREEN, NORMAL);
  printf("%s-S%s to read numbers from %sstdin%s\n", PINK, NORMAL, BOLDRED, NORMAL);
  printf("%s-l%s to listen for a %sresponse%s from the carrier\n", BOLDCYAN, NORMAL, PINK, NORMAL);
  printf("%s-s%s to send a %sstring%s to the carrier\n", BOLDGREEN, NORMAL, BOLDCYAN, NORMAL);
  printf("%s-c%s to read phone numbers from a %sconfig file%s.\n", YELLOW, NORMAL, BOLDCYAN, NORMAL);
  printf("%s-L%s to specify the %slogfile%s.\n", BOLDRED, NORMAL, PINK, NORMAL);

  putchar('\n');

  printf("The %slogfile%s is by default %s%s%s if not specified.\n", BOLDCYAN, NORMAL, BOLDGREEN, LOGFILE, NORMAL);
  printf("The %sconfig file%s is only specified if %s-c%s option is used.\n", PINK, NORMAL, BOLDCYAN, NORMAL);

  putchar('\n');
  exit(1);
}

/* -------------------------------------------------- */

void intro()
{
  printf("\t\t%sS%sh%so%sk%sd%si%sa%sl%s %s%s %sf%so%sr %sU%sN%si%sX%s\n", 
	  BLINKCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, BOLDWHITE, 
          BOLDRED,   PINK, BOLDBLUE, VERSION, NORMAL, PINK, BOLDCYAN,
          BOLDGREEN, BOLDPINK, BOLDGREEN, BOLDWHITE, BOLDBLUE, NORMAL);

  printf("\t\t----------------------\n");
  printf("\nWell what you do here, is enter 0000 for the range to begin\n");
  printf("scanning and 9999 to end scanning if you want to scan all the\n");
  printf("possible ranges, but you can put 4444 for the nmber to start\n");
  printf("and 5555 for the number to begin to scan XXX-[4444-5555] for\n"); 
  printf("local numbers and it would be 1-XXX-XXX-[4444-5555] for long\n");
  printf("distance.\n");
  printf("\nAlso, you can use random scanning (as opposed to sequential\n");
  printf("scanning) by specifying the \"%s-r%s\" option...type:\n", 
	  PINK, NORMAL);

  printf("%s%s%s -h %sfor %shelp%s.\n\n", 
	  BOLDRED, ProgName, BOLDRED, NORMAL, BOLDCYAN, NORMAL);

  printf("Anyway, enjoy!\n\n");

  printf("\t\t\t%s Shok %s\n\t\t    (%sMatt Conover%s)\n\n", 
	  BOLDBLUE, NORMAL, BOLDWHITE, NORMAL);

  printf("%sEmail%s: %sshok@dataforce.net%s\n",
         BOLDWHITE, NORMAL, PINK, NORMAL);

  printf("%sWWW%s: %shttp://www.w00w00.org/%s\n",
         BOLDWHITE, NORMAL, PINK, NORMAL);


  printf("Hit enter to continue...\n");
  getchar();
}

/* -------------------------------------------------- */

void daemonize_me() 
{
  pid_t pid;

  if ((pid = fork()) == ERROR) {
     perror("fork");
     exit(ERROR);
  }

  if (pid != 0) 
     exit(0);
}

/* -------------------------------------------------- */

void get_scanrange()
{

  /* Get location of numbers: local numbers or long distance numbers */
  LorD:
    printf("Scanning..\n(%sL%s)ocal, Long (%sD%s)istance: ", 
   	   PINK, NORMAL, PINK, NORMAL);

  while(1) {
     LocalOrLong = getchar();

     if (!isprint(LocalOrLong)) continue;
     if ((toupper(LocalOrLong) != 'L') && (toupper(LocalOrLong) != 'D')) {
        printf("%sInvalid%s option '%s%c%s'. Enter '%sL%s' or '%sD%s'.\n\n",
               BOLDRED, NORMAL, BOLDCYAN, LocalOrLong, NORMAL, YELLOW,
               NORMAL, YELLOW, NORMAL);
        goto LorD; /* Reprint message. */ 
    } else break;
  }

  if (toupper(LocalOrLong) == 'L') { /* Use local phone numbers */
     if (rand != 1) { /* Using sequential scanning */

        printf("Enter number to begin scan on (555-1111): ");
        scanf("%3d%*c%4d", &First3Digits, &ScanMin);

        local_validnum(First3Digits); /* Make sure the first 3 digits */
                                      /* were a valid number.         */

        ScanMin1 = ScanMin; /* ScanMin changes, so we need a second   */
   		            /* variable to store the original number. */

     } else { /* Using random scanning */

        printf("Enter the first 3 digits (555 for random scanning of 555-XXXX): ");
        scanf("%3d", &First3Digits);
	  
	local_validnum(First3Digits); /* Make sure the first 3 digits */
                                      /* were a valid number.         */

        ScanMin1 = ScanMin; /* ScanMin changes, so we need a second   */
 		            /* variable to store the original number. */
     }

     /* Make sure the last 4 digits were valid */
     if ((ScanMin < 0) || (ScanMin > 9999)) {
	printf("\"%s%d%s\" is invalid.\nScanning range must be %s0000-9999%s\n", 
		BOLDCYAN, ScanMin, NORMAL, PINK, NORMAL);
	exit(ERROR);
     }

     if (rand != 1) { /* Using sequential scanning */

        printf("Enter number to end scanning on (555-9999): ");
        scanf("%3d%*c%4d", &First3Digits1, &ScanMax);

        local_validnum(First3Digits1); /* Make sure the first 3 digits */
                                       /* were a valid number.         */ 
        putchar('\n');
  
        if ((ScanMax < ScanMin) || (ScanMax < 0) || (ScanMax > 9999)) {
  	   printf("\"%s%d%s\" is invalid.\n Scanning range must be %s0000-9999%s, and the %smaximum%s range must be %sgreater%s\nthan or equal to the %sminimum%s number.\n", 
		   BOLDCYAN, ScanMax, NORMAL, BOLDWHITE, NORMAL, PINK,
		   NORMAL, BOLDWHITE, NORMAL, PINK, NORMAL);

		exit(ERROR);
        }
     } else 
	putchar('\n');


  /* -------------------- */

  } else if (toupper(LocalOrLong) == 'D') { /* Use long distance numbers */

      if (rand != 1) { /* Use sequential scanning */
 	 printf("Enter number to start scanning (555-555-1111): ");
  	 scanf("%3d%*c%3d%*c%4d", &First3Digits, &Last3Digits, &ScanMin);

         /* Check if area code and first 3 digits of the phone num are */
         /* valid.						        */
	 long_validnum(First3Digits, Last3Digits);

         ScanMin1 = ScanMin; /* ScanMin changes, so we need a second   */
	  	             /* variable to store the original number. */

        /* ... */

      } else { /* Using random scanning */

	 printf("Enter the area code and prefix digits\n(555-555 for random scanning of 555-555-XXXX): ");
         scanf("%3d%*c%3d", &First3Digits, &Last3Digits);

         /* Check if area code and first 3 digits of the phone num are */
         /* valid.						       */
  	 long_validnum(First3Digits, Last3Digits);
 
         ScanMin1 = ScanMin; /* ScanMin changes, so we need a second   */
 		             /* variable to store the original number. */
      }

      /* Make sure the last 4 digits were valid */
      if ((ScanMin < 0) || (ScanMin > 9999)) {
 	 printf("\"%s%d%s\" is invalid.\nScanning range must be %s0000-9999%s\n", 
	 	 BOLDCYAN, ScanMin, NORMAL, PINK, NORMAL);
	 exit(ERROR);
      }

      if (rand != 1) { /* Using sequential scanning */

	 printf("Enter number to end scanning (555-555-9999): ");
  	 scanf("%3d%*c%3d%*c%4d", &First3Digits1, &Last3Digits1, &ScanMax);

  	 putchar('\n');
  
         /* Check if area code and first 3 digits of the phone num are */
         /* valid.						      */
  	 long_validnum(First3Digits1, Last3Digits1);

         if ((ScanMax < ScanMin) || (ScanMax < 0) || (ScanMax > 9999)) {
   	    printf("\"%s%d%s\" is invalid.\n Scanning range must be %s0000-9999%s, and the %smaximum%s range must be %sgreater%s\nthan or equal to the %sminimum%s number.\n", 
		    BOLDCYAN, ScanMax, NORMAL, BOLDWHITE, NORMAL, PINK,
		    NORMAL, BOLDWHITE, NORMAL, PINK, NORMAL);

	    exit(ERROR);
  	 }
      } else 
  	   putchar('\n');

  } else {
       printf("You must specify \"%sL%s\" for %slocal%s or \"%sD%s\" for %slong distance%s\n", 
	        PINK, NORMAL, BOLDCYAN, NORMAL, PINK, NORMAL, BOLDCYAN, NORMAL);
       exit(ERROR);
  }

}

/* -------------------------------------------------- */

void open_port()
{
  if (noshow != 1) printf("Opening modem for dialing...\n");

  fd = open(MODEMPORT, O_RDWR | O_NOCTTY);

  if (fd == ERROR) {
     perror("open");
     exit(ERROR);
  }
  
  noshow = 1; /* We use this function for reopening as well */
}

/* -------------------------------------------------- */

void init_modem()
{
  FILE *logfile;

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     close(fd);
     exit(ERROR);
  }

  printf("Initializing modem (port %s%s%s)....\n", PINK, MODEMPORT, NORMAL);

  /* Hang up modem if it's already on */
  
  hangup();

  numbytes = write(fd, "+++\r", 4);
  check_for_error(LogFile, fd, numbytes, "write");
  usleep(1000000);

  numbytes = write(fd, "ATZ\r", 4);
  check_for_error(LogFile, fd, numbytes, "write");
  usleep(2000000); /* Use this because we're using SIGALRM which   */
		   /* is what sleep() uses.			   */

  memset(buf, 0, sizeof(buf));
  numbytes = read(fd, buf, sizeof(buf));
  check_for_error(LogFile, fd, numbytes, "read");

  noOK = checkok(LogFile, fd, buf, "initializing modem");
  
  if (noOK == 1) {
     fclose(logfile);
     close(fd);
     exit(ERROR);
  }

  memset(buf, 0, sizeof(buf));

  fclose(logfile);
}

/* -------------------------------------------------- */

void dial_number()
{
  time_t tm;           /* Where we our calendar time is stored		*/
  FILE   *logfile;     /* for the log file 	   		        */
  char   date[32];     /* Contain time scanning started/stopped         */
  char   phonenum[20]; /* If local: phonenum = First3Digits + ScanMin   */
                       /* If long distance: phonenum =                  */
                       /* First3Digits + Last3Digits + ScanMin          */
    
  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }

  fprintf(logfile, "\n----------------------\n\n");
  fflush(logfile);

  memset(buf, 0, sizeof(date));
  memset(buf, 0, sizeof(buf));

  tm = time(NULL);
  sprintf(date, "%s", ctime(&tm));
  fprintf(logfile, "Started scanning at/on: %s", date);

  fflush(logfile);
  memset(date, 0, sizeof(date));

  if (daemon == 1) putchar('\n'); /* Just to make it look nicer */

  printf("Using a %s%d%s second connection %stimeout%s.\n", 
	  BOLDCYAN, TIMEOUT, NORMAL, BOLDWHITE, NORMAL);

  
  if (toupper(LocalOrLong) == 'L') {  /* Local call */

     fprintf(logfile, "Scanning local numbers...\n");
     fprintf(logfile, "Using a %d second connection timeout.\n", TIMEOUT);
     fprintf(logfile, "Starting scanning with %d-%.4d\n\n", 
	     First3Digits, ScanMin);

     fflush(logfile);

     while (1) {
        if (rand == 1) ScanMin = (random() % 8889) + 11;

      	printf("Dialing %s%d-%.4d%s...\n", 
	        PINK, First3Digits, ScanMin, NORMAL);

	memset(phonenum, 0, sizeof(phonenum));
	sprintf(phonenum, "ATDT%d%.4d\r", First3Digits, ScanMin);

       	numbytes = write(fd, phonenum, strlen(phonenum));
	check_for_error(LogFile, fd, numbytes, "write");

	memset(buf, 0, sizeof(buf));

        alarm(TIMEOUT); /* How long to wait for timeout   */

	sig = 0;
        connected = 1; /*  
			* Easier to set it to 1 and then set it
			* to 0 if it's not than vice versa.
			*/
	do {
           numbytes = read(fd, buf, 511);
	   if (sig == 1) break;
			
	} while ((strstr(buf, "CONNECT")) == NULL);

	alarm(0); /* Turn alarm off if we haven't already. */

	if (connected == 0) noresponse++;
	else if ((strstr(buf, "BUSY")) != NULL) busy++;

       	/* Compare the string with "CONNECT" */
        if (connected == 1) { /* Sighandler sets this to 0 when  */
			      /* it's called...meaning time out. */
#ifdef BEEP
           putchar('\a');
#endif

	   connect++;

           fprintf(logfile, "*** CONNECT *** to %d-%.4d\n",  
		   First3Digits, ScanMin);

 	   printf("%s*** %sCONNECT %s%s*** %s to %s%d-%.4d%s\n", 
	 	    BOLDWHITE, BOLDCYAN, NORMAL, BOLDWHITE, NORMAL, 
		    PINK, First3Digits, ScanMin, NORMAL);

           /* Send a string to the carrier and check for response */
           if (send && listen) { /* send poke string and listen for reply */

              if (write(fd, sendstring, sizeof(sendstring)) == ERROR) {
		 perror("write");

		 close(fd);
                 fclose(logfile);
		 exit(ERROR);
              }

              response = 1; /* Sighandler will set this to 0 when it */
                            /* times out                             */

              printf("response from carrier (after sending string): ");
              fprintf(logfile, "response from carrier (after sending string): ");
              fflush(stdout), fflush(logfile);

	      if (read(fd, buf, sizeof(buf)) == ERROR) {
		 perror("read");
                 printf("continuing anyway...\n");
	      }

              if (response == 1) {
                 printf("%s\n", buf);
                 fprintf(logfile, "%s\n", buf);
              } else {
                 printf("timed out while waiting for response\n");
                 fprintf(logfile, "timed out while waiting for response\n");
              }
           } else { /* listen = 1, send = 0 */

              response = 1; /* The sighandler will set this to 0 if it */
                            /* times out                               */

              printf("response from carrier: ");
              fprintf(logfile, "response from carrier: ");

	      if (read(fd, buf, sizeof(buf)) == ERROR) {
		 perror("read");
                 printf("continuing anyway...\n");
	      }

              if (response == 1) {
                 printf("%s\n", buf);
                 fprintf(logfile, "%s\n", buf);
              } else {
                 printf("timed out while waiting for response\n");
                 fprintf(logfile, "timed out while waiting for response\n");
              }
           }
        }

        memset(buf, 0, sizeof(buf)); 

	hangup();

	if (rand != 1) {
	   /* Increase ScanMin so it scans for the next number */
	   ScanMin++;
            
           if (ScanMin > ScanMax) {
 	      /* If they are different...then they are scanning */
              /* something like: 555-XXXX through 556-XXXX.     */
   
              /* So now we reset everything.       */

              /* 
               * If you did: 755-XXXX through 757-XXXX, we need to 
               * increase the 755 and repeat until they are the same. 
               */

               if (First3Digits !=  First3Digits1) {

   	          First3Digits++; 
	          ScanMin = ScanMin1; /* Restored ScanMin to its */
                                      /* original value.         */
  	          continue;
	       }

	       memset(buf, 0, sizeof(buf));

#ifdef BEEP
               putchar('\a');
#endif

	       fprintf(logfile, "\nFinished scanning %d-%.4d through %d-%d.\n", 
   		       First3Digits, ScanMin1, First3Digits, ScanMax);
				
	       memset(date, 0, sizeof(date));
	       tm = time(NULL);
	       sprintf(date, "%s", ctime(&tm));

	       fprintf(logfile, "Finished at/on: %s", date);
	       fflush(logfile);				

	       printf("Finished scanning %s%d-%.4d %sthrough %s%d-%.4d%s.\n", 
		       BOLDCYAN, First3Digits, ScanMin1, NORMAL, 
		       BOLDCYAN, First3Digits, ScanMax,  NORMAL);

     	       /* Print statistics. */
   	       printf("%sResults%s:\n", BOLDRED, NORMAL);

	       printf("\t# of %ssuccessful connects%s: %s%d%s\n", 
	               BOLDCYAN, NORMAL, PINK, connect, NORMAL);

	       printf("\t# of lines %sbusy%s: %s%d%s\n", 
	               YELLOW, NORMAL, PINK, busy, NORMAL);

	       printf("\t# of %sno responses (timed out)%s: %s%d%s\n", 
		       BOLDGREEN, NORMAL, PINK, noresponse, NORMAL);


  	       printf("Thanks for using %sS%sh%so%sk%sD%si%sa%sl %s%s%s.\n", 
 		       BLINKCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, 
                       BOLDWHITE, BOLDRED, PINK, BOLDBLUE, VERSION, NORMAL);

	       return;
           } 
        }

	memset(phonenum, 0, sizeof(phonenum));

    }
  } else { /* (Long Distance call) */ 

        memset(buf, 0, sizeof(buf));

	fprintf(logfile, "Scanning long distance numbers...\n");
        fprintf(logfile, "Using a %d second connection timeout.\n", TIMEOUT);
	fprintf(logfile, "Started scanning with 1-%.3d-%.3d-%.4d\n\n", 
		First3Digits, Last3Digits, ScanMin);

        fflush(logfile);

	while(1) {
  	   if (rand == 1) ScanMin = (random() % 8889) + 1111;

	   printf("Dialing %s1-%.3d-%.3d-%.4d%s...\n", 
	  	   PINK, First3Digits, Last3Digits, ScanMin, NORMAL);

 	   memset(phonenum, 0, sizeof(phonenum));
	   sprintf(phonenum, "ATDT1%.3d%.3d%.4d\r", 
		   First3Digits, Last3Digits, ScanMin);

           numbytes = write(fd, phonenum, strlen(phonenum));
           check_for_error(LogFile, fd, numbytes, "write");
               
           memset(buf, 0, sizeof(buf));

           alarm(TIMEOUT); /* How long to wait for timeout. */

           sig = 0;
           connected = 1; /* 
                           * Easier to say it's connected and then
                           * set it to 0 if it's not than vice versa.
                           */
           do {
              numbytes = read(fd, buf, 511);
	      if (sig == 1) break;
           } while ((strstr(buf, "CONNECT")) == NULL); 
	
 	   alarm(0);

	   if (connected == 0) noresponse++;
	   else if ((strstr(buf, "BUSY")) != NULL) busy++;

           if (connected == 1) { /* The sighandler sets this to 0 when */
				 /* it gets called.                    */

#ifdef BEEP
              putchar('\a');
#endif

     	      connect++;

 	      fprintf(logfile, "*** CONNECT *** to 1-%.3d-%.3d-%.4d\n", 
		      First3Digits, Last3Digits, ScanMin);
	      fflush(logfile);

	      printf("%s*** %sCONNECT %s%s*** %sto %s1-%.3d-%.3d-%.4d%s\n",
		      BOLDWHITE, BOLDCYAN, NORMAL, BOLDWHITE, NORMAL, PINK,
		      First3Digits, Last3Digits, ScanMin, NORMAL); 

              /* Send a string to the carrier and check for response */
              if (send && listen) { /* send poke string and listen for reply */

                 if (write(fd, sendstring, sizeof(sendstring)) == ERROR) {
		    perror("write");

		    close(fd);
                    fclose(logfile);
		    exit(ERROR);
                 }

                 response = 1; /* The sighandler sets this to 1 if it */
                               /* times out                           */

                 printf("response from carrier (after sending string): ");
                 fprintf(logfile, "response from carrier (after sending string): ");
                 fflush(stdout), fflush(logfile);

  	         if (read(fd, buf, sizeof(buf)) == ERROR) {
		    perror("read");
                    printf("continuing anyway...\n");
	         }

                 if (response == 1) {
                    printf("%s\n", buf);
                    fprintf(logfile, "%s\n", buf);
                 } else {
                    printf("timed out while waiting for response\n");
                    fprintf(logfile, "timed out while waiting for response\n");
		 }

              } else { /* listen = 1, send = 0 */

                 response = 1; /* The sighandler sets this to 1 if it */
                               /* times out.                          */

                 printf("response from carrier: ");
		 fprintf(logfile, "response from carrier: ");
		 fflush(stdout), fflush(logfile);

	         if (read(fd, buf, sizeof(buf)) == ERROR) {
		    perror("read");
                    printf("continuing anyway...\n");
	         }

                 if (response == 1) { 
                    printf("%s\n", buf);
                    fprintf(logfile, "%s\n", buf);
                 } else {
                    printf("timed out while waiting for response\n");
                    fprintf(logfile, "timed out while waiting for response\n");
                 }
              }
           }

           memset(buf, 0, sizeof(buf));

	   hangup(); 

           if (rand != 1) {

              /* Increase ScanMin so it scans for the next number */
      	      ScanMin++;
                        
             if (ScanMin > ScanMax) {

		/* If they are different...then they are scanning */
                /* something like: 555-XXXX through 556-XXXX.     */
  
                /* So now we reset everything.       */

                /* 
                 * If you did: 555-755-XXXX through 
                 * 555-757-XXXX, we need to increase 
                 * the 755 and repeat until they are the
                 * same. 
                 */

                 if ((First3Digits    != First3Digits1) 
                      || (Last3Digits != Last3Digits1)) {

		    if (First3Digits != First3Digits1) First3Digits++;
		    if (Last3Digits  != Last3Digits1)  Last3Digits++;

		    ScanMin = ScanMin1; /* Restore to its original value */
		    continue;
		 }

		 memset(buf, 0, sizeof(buf));

#ifdef BEEP
                 putchar('\a');
#endif 

		 fprintf(logfile, "\nFinished scanning 1-%.3d-%.3d-%.4d through 1-%.3d-%.3d-%.4d.\n", 
 			 First3Digits, Last3Digits, ScanMin1, First3Digits, 
                         Last3Digits, ScanMax);
				
 		 memset(date, 0, sizeof(date));
		 tm = time(NULL);
		 sprintf(date, "%s", ctime(&tm));
			
		 fprintf(logfile, "Finished at/on: %s", date); 
		 fflush(logfile);

		 printf("Finished scanning %s1-%.3d-%.3d-%.4d%s through %s1-%.3d-%.3d-%.4d%s", 
 			 BOLDCYAN, First3Digits, Last3Digits, ScanMin1, 
			 NORMAL, BOLDCYAN, First3Digits, Last3Digits, 
			 ScanMax, NORMAL);

		 /* Print statistics. */
		 printf("%sResults%s:\n", BOLDRED, NORMAL);

	         printf("\t# of %ssuccessful connects%s: %s%d%s\n", 
		         BOLDCYAN, NORMAL, PINK, connect, NORMAL);

  		 printf("\t# of %sbusy (timed out)%s: %s%d%s\n", 
		         YELLOW, NORMAL, PINK, busy, NORMAL);

  		 printf("\t# of %sno responses (timed out)%s: %s%d%s\n", 
		         BOLDGREEN, NORMAL, PINK, noresponse, NORMAL);


                 printf("Thanks for using %sS%sh%so%sk%sD%si%sa%sl %s%s%s\n", 
		 	 BLINKCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, 
                         BOLDWHITE, BOLDRED, PINK, BOLDBLUE, VERSION, NORMAL);


                 break;
             }
 	  }

          memset(phonenum, 0, sizeof(phonenum));
        } 
  } 

  fclose(logfile);
} 

/* --------------------------------------- */

void confdial(char *confile)
{
  time_t tm;           /* Where we our calendar time is stored		*/
  FILE   *logfile;     /* For the log file 	   		        */
  FILE   *confd;       /* For the config file                           */
  char   date[32];     /* Contain time scanning started/stopped         */
  char   pnum1[20];    /* Phone # without the '-'s and what not.        */
  char   phonenum[20]; /* This will include the ATDT etc.               */
    
  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }

  fprintf(logfile, "\n----------------------\n\n");
  fflush(logfile);

  if ((confd = fopen(confile, "r")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }

  memset(buf,  0, sizeof(buf));
  memset(date, 0, sizeof(date));

  tm = time(NULL);
  sprintf(date, "%s", ctime(&tm));

  printf("Reading phone numbers from \"%s%s%s\".\n", PINK, confile, NORMAL);

  printf("\nNOTE: There is no checking of the phone number for -c or -s\n"
         "to allow you to enter odd strings such as \"5551234,,,5#\".\n\n");

  fprintf(logfile, "Started at/on: %s\n"
		   "Reading phone numbers from config file \"%s\".\n", 
	            date, confile);

  fflush(logfile);
  memset(date, 0, sizeof(date));

  if (daemon == 1) putchar('\n'); /* Just to make it look nicer */

  printf("Using a %s%d%s second connection %stimeout%s.\n", 
	  BOLDCYAN, TIMEOUT, NORMAL, BOLDWHITE, NORMAL);

  
  memset(pnum1, 0, sizeof(pnum1));
  memset(phonenum, 0, sizeof(phonenum));

  while (!feof(confd)) {
     if ((fgets(pnum, 512, confd)) == NULL) {
	perror("fgets");
	exit(ERROR);
     }

     if (pnum[0] == '\n')
	continue;

     if ((strstr(pnum, "#")) != NULL) {

	if (pnum[0] == '#')
 	   continue; 
	else {
	   /* Well either there are some spaces, or a */
	   /* number before the comment               */

	   char *p, *p1;
	   char temp[20];

	   memset(temp, 0, sizeof(temp));

	   p = pnum, p1 = temp;

 	   while(*p == '\t' || *p == ' ')
	      *p += 1;

	      if (*p == '#') /* Just some space and a comment */
	 	 continue;
              else { /* Okay it's a number */
	         while(*p != '\t' || *p != ' '  || \
                       *p != '\n' || *p != '\0' || *p != '#')
		    *p1++ = *p++;

		    sprintf(pnum, "%s", temp);	
				
	      }
	}

     }

     fprintf(logfile, "Dialing %s\n", pnum);
     fflush(logfile);

     strip(pnum, pnum1);

     printf("Dialing %s%s%s\n", BOLDCYAN, pnum, NORMAL);

     sprintf(phonenum, "ATDT%s\r", pnum1);

     numbytes = write(fd, phonenum, strlen(phonenum));
     check_for_error(LogFile, fd, numbytes, "write");

     memset(buf, 0, sizeof(buf));

     alarm(TIMEOUT); /* How long to wait for timeout   */

     sig = 0;
     connected = 1; /* 
        	     * Easier to set it to 1 and then set it
		     * to 0 if it's not than vice versa
		     */

     do {
        numbytes = read(fd, buf, 511);
	if (sig == 1) break;
     } while ((strstr(buf, "CONNECT")) == NULL);

     alarm(0); /* Stop the timing. */

     /* Compare the string with "CONNECT" */
     if (connected == 1) {
#ifdef BEEP
        putchar('\a');
#endif

        fprintf(logfile, "*** CONNECT *** to %s", pnum);
	printf("%s*** %sCONNECT %s%s*** %s to %s%s%s\n", 
	        BOLDWHITE, BOLDCYAN, NORMAL, BOLDWHITE, NORMAL, 
	        PINK, pnum, NORMAL);

        /* Send a string to the carrier and check for response */
        if (send && listen) { /* send poke string and listen for reply */

           if (write(fd, sendstring, sizeof(sendstring)) == ERROR) {
	      perror("write");
	      close(fd);
	      exit(ERROR);
           }

           response = 1; /* Sighandler will set this to 0 if it times out */

           printf("response from carrier (after sending string): ");
           fprintf(logfile, "response from carrier (after sending string): ");
           fflush(stdout), fflush(logfile);

	   if (read(fd, buf, sizeof(buf)) == ERROR) {
	      perror("read");
              printf("continuing anyway...\n");
	   }

           if (response == 1) {
              printf("%s\n", buf);
              fprintf(logfile, "%s\n", buf);
           } else {
	      printf("timed out while waiting for response\n");
	      fprintf(logfile, "timed out while waiting for response\n");
           }
        } else { /* listen = 1, send = 0 */

           response = 1; /* The sighandler will set this to 0 if it */
                         /* times out                               */

           printf("response from carrier: ");
           fprintf(logfile, "response from carrier: ");

	   if (read(fd, buf, sizeof(buf)) == ERROR) {
	      perror("read");
              printf("continuing anyway...\n");
	   }

           if (response == 1) {
              printf("%s\n", buf);
              fprintf(logfile, "%s\n", buf);
           } else {
              printf("timed out while waiting for response\n");
              fprintf(logfile, "timed out while waiting for response\n");
           }
        }
     }

     memset(buf, 0, sizeof(buf));

     hangup();
  }

#ifdef BEEP
  putchar('\a');
#endif

  memset(date, 0, sizeof(date));
  tm = time(NULL);
  sprintf(date, "%s", ctime(&tm));

  fprintf(logfile, "Finished dialing at/on: %s", date);
  fflush(logfile);				

  printf("Finished dialing!!\n"); 

  printf("Thanks for using %sS%sh%so%sk%sD%si%sa%sl %s%s%s.\n", 
 	  BLINKCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, BOLDWHITE, 
          BOLDRED, PINK, BOLDBLUE, VERSION, NORMAL);

  fclose(logfile);
  return;
} 

/* -------------------------------------- */

void inputdial()
{
  time_t tm;           /* Where we our calendar time is stored		*/
  FILE   *logfile;     /* For the log file 	   		        */
  char   date[32];     /* Contain time scanning started/stopped         */
  char   phonenum[20]; /* This will include the ATDT etc.               */
    
  /* Get location of numbers: local numbers or long distance numbers */

  LorD:
    printf("Scanning..\n(%sL%s)ocal, Long (%sD%s)istance: ", 
   	   PINK, NORMAL, PINK, NORMAL);

  while(1) {
     LocalOrLong = getchar();

     if (!isprint(LocalOrLong)) continue;
     if ((toupper(LocalOrLong) != 'L') && (toupper(LocalOrLong) != 'D')) {
        printf("%sInvalid%s option '%s%c%s'. Enter '%sL%s' or '%sD%s'.\n\n",
               BOLDRED, NORMAL, BOLDCYAN, LocalOrLong, NORMAL, YELLOW,
               NORMAL, YELLOW, NORMAL);
        goto LorD; /* Reprint message. */ 
    } else break;
  }

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }

  fprintf(logfile, "\n----------------------\n\n");
  fflush(logfile);

  memset(buf,  0, sizeof(buf));
  memset(date, 0, sizeof(date));

  tm = time(NULL);
  sprintf(date, "%s", ctime(&tm));

  fprintf(logfile, "Started at/on: %s\n", date);
  fprintf(logfile, "Reading phone numbers stdin.\n");

  fflush(logfile);
  memset(date, 0, sizeof(date));

  if (daemon == 1) putchar('\n'); /* Just to make it look nicer */

  printf("Using a %s%d%s second connection %stimeout%s.\n", 
	  BOLDCYAN, TIMEOUT, NORMAL, BOLDWHITE, NORMAL);

  memset(phonenum, 0, sizeof(phonenum));

  printf("When finished, enter \"%s.%s\" as the number.\n", 
         BOLDWHITE, NORMAL); 

  printf("\nNOTE: There is no checking of the phone number for -c or -s\n"
         "to allow you to enter odd strings such as \"5551234,,,5#\".\n\n");

  signal(SIGINT,  sighandler);
  signal(SIGTERM, sighandler);

  while (1) {
     if (toupper(LocalOrLong) == 'L') { /* Use local phone numbers */

        printf("Enter phone number (i.e. 555-5555): ");
        scanf("%3d%*c%4d", &First3Digits, &ScanMin);

        /* First3Digits and ScanMin will both be 0 if "." is entered */
        if (First3Digits == 0 && ScanMin == 0) goto finished; 

        sprintf(pnum, "%.3d%.4d", First3Digits, ScanMin);

        fprintf(logfile, "Dialing %.3d-%.4d\n", First3Digits, ScanMin);
        fflush(logfile);

     } else { /* LocalOrLong == 'D', use long distance phone numbers */

        printf("Enter phone number (i.e. 555-555-5555): ");
        scanf("%3d%*c%3d%*c%4d", &First3Digits, &Last3Digits, &ScanMin);

        /* First3Digits and ScanMin will both be 0 if "." is entered */
        if (First3Digits == 0 && ScanMin == 0 && Last3Digits == 0) 
           goto finished; 

        sprintf(pnum, "1%.3d%.3d%.4d", First3Digits, Last3Digits, ScanMin);

        fprintf(logfile, "Dialing %.3d-%.3d-%.4d\n", 
                First3Digits, Last3Digits, ScanMin);
        fflush(logfile);
     }

     sprintf(phonenum, "ATDT%s\r", pnum);
     numbytes = write(fd, phonenum, strlen(phonenum));
     check_for_error(LogFile, fd, numbytes, "write");

     memset(buf, 0, sizeof(buf));

     alarm(TIMEOUT); /* How long to wait for timeout   */

     sig = 0;
     connected = 1; /* 
         	     * Easier to set it to 1 and then set it
		     * to 0 if it's not than vice versa
		     */

     do {
        numbytes = read(fd, buf, 511);
	if (sig == 1) break;
     } while ((strstr(buf, "CONNECT")) == NULL);

     alarm(0); /* Stop the timing. */

     /* Compare the string with "CONNECT" */
     if (connected == 1) {
#ifdef BEEP
        putchar('\a');
#endif

        fprintf(logfile, "*** CONNECT *** to %s", pnum);
	printf("%s*** %sCONNECT %s%s*** %s to %s%s%s\n", 
               BOLDWHITE, BOLDCYAN, NORMAL, BOLDWHITE, NORMAL, 
               PINK, pnum, NORMAL);

        if (send && listen) { /* send poke string and listen for reply */

           if (write(fd, sendstring, sizeof(sendstring)) == ERROR) {
	      perror("write");
	      close(fd);
	      exit(ERROR);
           }

           response = 1; /* The sighandler returns 0 when it times out */

           printf("response from carrier (after sending string): ");
           fprintf(logfile, "response from carrier (after sending string): ");
           fflush(stdout), fflush(logfile);

	   if (read(fd, buf, sizeof(buf)) == ERROR) {
	      perror("read");
              printf("continuing anyway...\n");
	   }

           if (response == 1) {
               printf("%s\n", buf);
               fprintf(logfile, "%s\n", buf);
           } else {
               printf("timed out while waiting for response\n");
               fprintf(logfile, "timed out while waiting for response\n");
           }
        } else { /* listen = 1, send = 0 */

           response = 1; /* The sighandler will set this to 0 if it */
                         /* times out                               */

           printf("response from carrier: ");
           fprintf(logfile, "response from carrier: ");
           fflush(stdout), fflush(logfile);

	   if (read(fd, buf, sizeof(buf)) == ERROR) {
	      perror("read");
              printf("continuing anyway...\n");
	   }

           if (response == 1) {
              printf("%s\n", buf);
              fprintf(logfile, "%s\n", buf);
           } else {
              printf("timed out while waiting for response\n");
              fprintf(logfile, "timed out while waiting for response\n");
           }
        }
     }

     memset(buf, 0, sizeof(buf));

     hangup();
  }


  finished:
     memset(date, 0, sizeof(date));
     tm = time(NULL);
     sprintf(date, "%s", ctime(&tm));

     fprintf(logfile, "User ended dialing at/on: %s", date);
     fflush(logfile);				

     printf("Okay I hope you enjoyed it!\n"); 

     printf("Thanks for using %sS%sh%so%sk%sD%si%sa%sl %s%s%s.\n", 
   	    BLINKCYAN, BOLDGREEN, BOLDBLUE, BOLDPINK, YELLOW, BOLDWHITE, 
            BOLDRED, PINK, BOLDBLUE, VERSION, NORMAL);

     fclose(logfile);
     return;
} 

/* -------------------------------------- */

void hangup()
{
  FILE *logfile;

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }
    
  /* 
   * The reason we write "ATH" to a nonconnected host is that
   * this is fine. But when it's connected... +++ is sent as
   * the login name, and ATH as the password (not a good thing
   * to be logged on a remote host anyway. ;)
   * If it is connected we will take the less effecient method
   * of closing and reopening the fd to hang up
   */
 
  if (connected != 1) {
     numbytes = write(fd, "+++\r", 4);
     check_for_error(LogFile, fd, numbytes, "write");

     usleep(500000);
     memset(buf, 0, sizeof(buf));

     numbytes = write(fd, "ATH0\r", 5);
     check_for_error(LogFile, fd, numbytes, "write");


     /* 
      * We're using SIGALRM, and sleep() uses sig alarm
      * and usleep() doesn't. 				
      */

     usleep(1000000); 

     numbytes = read(fd, buf, sizeof(buf));
     check_for_error(LogFile, fd, numbytes, "read");
     usleep(2000000);

     if (noOK != 1) noOK = checkok(LogFile, fd, buf, "hanging up modem");
     else {
        /* There was an error getting an "OK" from the modem */
        fclose(logfile);
        close(fd), exit(ERROR);
     }

     if (noOK == 1) {
        /* There was an error getting an "OK" from the modem */
        fclose(logfile);
        close(fd), exit(ERROR);
     }

  } else {
      if (close(fd) == ERROR) {
	 perror("close");
	 exit(ERROR);
      }

      open_port();
      connected = 0;
  }

  memset(buf, 0, sizeof(buf));
  fclose(logfile);
}

/* -------------------------------------- */

/* The reason I have two different sighandler functions, rather than */
/* just basing off the signal number, is simplicity.                 */


void sighandler(int signum)
{
  FILE   *logfile;
  char   date[32]; /* Where the date for the ending time is stored. */
  time_t tm;       /* Where calendar time is stored.                */

  memset(date, 0, sizeof(date));

  /* Just exit on one of these signals. */
  signal(SIGINT,  stopnow);
  signal(SIGTERM, stopnow);

  tm = time(NULL);
  sprintf(date, "%s", ctime(&tm));

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     exit(ERROR);
  }

  printf("%sReceived signal to quit%s:\nClosing up modem, logging, and exitting.\n", 
	  BOLDRED, NORMAL);
  fprintf(logfile, "\nReceived signal to quit. Aborting.\n");
  fflush(logfile);

  if (conf == 1) {
     fprintf(logfile, "Last number dialed was %s", pnum);
     close(fd);
     fclose(logfile);
     exit(ERROR);
  }

  if (toupper(LocalOrLong) == 'L') { /* Use local phone numbers */
     if (rand != 1 || conf != 1) {
	fprintf(logfile, "Last number dialed was %.3d-%.4d.\n", 
                First3Digits, ScanMin);

        printf("Last number dialed was %s%.3d-%.4d%s.\n", 
	        BOLDCYAN, First3Digits, ScanMin, NORMAL);
     }

     fprintf(logfile, "Results:\n");
     fprintf(logfile, "\t# of successful connects: %d\n", connect);
     fprintf(logfile, "\t# of busy numbers: %d\n", busy);
     fprintf(logfile, "\t# of no responses (timed out): %d\n", noresponse);

  } else { /* if LocalOrLong == 'D' */
       if (rand != 1 || conf != 1) {
 	  fprintf(logfile, "Last number dialed was 1-%.3d-%.3d-%.4d.\n", 
	  	  First3Digits, Last3Digits, ScanMin);

	  printf("Last number dialed was %s1-%.3d-%.3d-%.4d%s.\n", 
		  BOLDCYAN, First3Digits, Last3Digits, ScanMin, NORMAL);
       }

       fprintf(logfile, "Results:\n");
       fprintf(logfile, "\t# of successful connects: %d\n", connect);
       fprintf(logfile, "\t# of busy numbers: %d\n", busy);
       fprintf(logfile, "\t# of no responses (timed out): %d\n", noresponse);

  }

  /* Print statistics. */
  printf("%sResults%s:\n", BOLDRED, NORMAL);

  printf("\t# of %ssuccessful connects%s: %s%d%s\n", 
          BOLDCYAN, NORMAL, PINK, connect, NORMAL);

  printf("\t# of %sno responses (timed out)%s: %s%d%s\n", 
          YELLOW, NORMAL, PINK, busy, NORMAL);

  printf("\t# of %sno responses (timed out)%s: %s%d%s\n", 
          BOLDGREEN, NORMAL, PINK, noresponse, NORMAL);


  fprintf(logfile, "Aborted at: %s", date);
  fflush(logfile);

  noshow = 1; /* So we don't get 'Opening modem for dialing' because  */
              /* we use open_port() for both hanging up and dialing.  */

  hangup(); 

  close(fd);
  fclose(logfile);

  exit(0);
}

/* -------------------------------------- */

void sighandler1(int signum)
{  
   signal(SIGALRM, sighandler1);

   sig = 1;
   response = 0;
   connected = 0;
}

/* -------------------------------------- */
 
void menu(int signum)
{
  char ch;

  signal(SIGINT, sighandler);
  signal(SIGTERM, sighandler);

  printf("\n\n1. Hang up modem and skip to next number\n");
  printf("2. Hang up modem and exit\n\n");
  printf("Enter 1 or 2: ");

  while (1) {
     fflush(stdout);
  
     ch = getchar();

     if (ch == '1') {

        alarm(0); /* Stop the timeout timer. */

        /* Just act like the number timed out. sighandler1 is */
        /* the sig handler called when a number times out.    */
        sighandler1(0); 

        /* Reset signal handlers. */
        signal(SIGINT,  menu);
        signal(SIGTERM, menu);

        break;
     } else if (ch == '2') {
        /* Sig handler used to exit. So we will just call this. */
        sighandler(0); 

     } else
	if (isprint(ch)) printf("Invalid option.\nEnter 1 or 2: ");
  }
}

void stopnow(int signum)
{
  /* Exit immediately. */
  exit(ERROR);
}
