;--------------------------------------------------
; convert an 32-bit uint into ascii (4 digits)
;--------------------------------------------------

hex2int: /* char **ptr, int *intValue */
   int hexValue;
   int numChars = 0;

   *intValue = 0;

   while (**ptr)
   {
      hexValue = hex(**ptr);

      if (hexValue >= 0)
      {
         *intValue = (*intValue << 4) | hexValue;
         numChars++;
      }
      else break;

      (*ptr)++;    
   }

   return (numChars);


;--------------------------------------------------
; convert an 8-bit hex char into a 8-bit ascii #
;--------------------------------------------------

hex2char:

  if ((ch >= 'a') && (ch <= 'f')) return (ch-'a'+10);
  else if ((ch >= 'A') && (ch <= 'F')) return (ch-'A'+10);
  else if ((ch >= '0') && (ch <= '9')) return (ch-'0');

  return (-1);


;--------------------------------------------------
; convert a string from memory into a hex string
;--------------------------------------------------

mem2hex:
   int i; 
   unsigned char ch;

   char hexchars[] = "0123456789abcdef";

   if (may_fault) mem_fault_routine = set_mem_err;

   for (i = 0; i < count; i++)
   {
      ch = get_char(mem++);

      if (may_fault && mem_err) return (buf);
      *buf++ = hexchars[ch >> 4], *buf++ = hexchars[ch % 16];
   }

   *buf = 0;

   if (may_fault) mem_fault_routine = NULL;
   return(buf);


;--------------------------------------------------
; convert a string from memory into a hex string
;--------------------------------------------------

hex2mem:
   int i;
   unsigned char ch;

   if (may_fault) mem_fault_routine = set_mem_err;

   for (i = 0; i < count; i++)
   {
      ch = hex(*buf++) << 4, ch += hex(*buf++);

      set_char (mem, ch), mem++;
      if (may_fault && mem_err) return (mem);
   }

   if (may_fault) mem_fault_routine = NULL;
   return(mem);


