; this file has functions to halt/reboot the computer
; ---------------------------------------------------

;--------------------------------------------------------
; used to reboot the computer (bios style)
;--------------------------------------------------------

reboot:
	mov si,rebootmsg	; load ds:si with the message for printmsg
	call printmsg		; output the "now rebooting" message

	call getkey		; wait for user input

	; load one of the below values into BIOS addr 40:72 in real mode
	; note: it will re-enter at 0040:0067

	; 0x0000 = cold boot, 0x1234 = warm boot
	mov ax,40		; use extra segment as bios segment
	mov es,ax		; copy seg addr into es

	mov bx,72		; offset into bios

	mov word [es:bx],0x1234	; set up to do a cold boot

	jmp 0ffffh:0fff0h	; jump to cause the actual reboot

	; should never get here
	jmp halt		; if this fails.. try plain reboot


;--------------------------------------------------------
; used to halt the computer
;--------------------------------------------------------

halt:
	cli			; disable interrupts

	mov si,haltmsg		; put msg in ds:si for printmsg
	call printmsg		; print the "system halted" message

.halt1:	hlt			; do halt (idle)
	jmp short .halt1	; loop here endlessly

