; this file has functions to output/prepare messages
; ---------------------------------------------------

;---------------------------------------------------------
; clear the screen 
;---------------------------------------------------------
clearscreen:
	push ax

	xor ax,ax		; clear/empty ax
	mov al,3		; set it to mode 3
	int 10h			; video interrupt

	pop ax
	ret


;---------------------------------------------------------
; print the startup messages
;---------------------------------------------------------
printbootmsgs:
	push dx			; save the old values
	push si

	mov si,bootmsg		; load the bootup message into ds:si
	call printmsg		; display message to screen

	cmp dl,0x80		; Compare the boot drive to 0x80 (C: drive)
	jae short printhd	; If dl (boot drive) <= 0x80 (C: drive) jmp

	add dl,'A'		; drive # we booted off in dl (if floppy)


printbootmsgs1:
	call printdrv

	pop si			; restore the old values
	pop dx

	ret			; return from this function

;--------------------------------------------------------
; used when the boot drive was a hard drive (ie C:)	
;--------------------------------------------------------

printhd:
	sub dl,0x3d			; 0x80 - 0x3d = 0x43 (C: drive)
	jmp short printbootmsgs1	; jump back to printbootmsgs


;---------------------------------------------------------
; output the actual boot drive message to the screen
;---------------------------------------------------------

printdrv:			; used to print drive # (for all types)
	mov byte [bootdrv],dl	; put the boot drive # into bootdrv

	mov si,bootdrv		; put the drive # in ds:si for printmsg
	call printmsg		; print the drive # to the screen

	ret			; return from this function


;--------------------------------------------------------
; print a message to the screen using the video interrupt
;--------------------------------------------------------

printmsg:
	push ax			; save the old values
	push bx
	push si

.printmsg1:
	cld			; clear the direction flag

	lodsb			; read one byte from ds:si into al at a time
	or al,al		; test if al is 0 (indicating end of str)
 	jz short printdone	; if it is 0, end (return)

	mov ah,0eh		; print a character to screen 
	mov bh,0		; page 0 of screen (normal page)
	int 10h			; BIOS video interrupt

	jmp short .printmsg1

done:	ret			; done here is used by several functions

printdone:
	pop si			; save the old values
	pop bx
	pop ax

	ret
