; Boot sector code [1st stage boot loader] (main file)
; Designed for the w00os (official WSD/w00w00 OS)
; See http://www.w00w00.org.
;
; Developed in Oct '98 by Matt Conover [Shok] (mattc@repsec.com) and the 
; w00brothers, for NASM (Netwide Assembler). See http://www.nasm.org.
;
; Compile using: nasm -f bin -o boot.bin boot.asm
;
; Then to write it to a floppy disk.. you have 2 choices:
; In Unix: run 'dd if=boot.img of=/dev/fd0' (or whichever drive you want)
; In DOS: run 'rawrite.exe boot.img a:' (or whatever drive you want)
;
; First, this will do things the basics such as check for at least a 386
; processor, output bootup messages and drives, etc. Second, it will 
; load the 2nd stage boot loader off sector 2 into 0x10000 (1000:0000), 
; and jump to there.
;
; It is up to the 2nd stage boot loader to do things such as load into 
; protected mode and setup the system for kernel initialization.

%include "boot.inc"		; include basic macro definitions

;---------------------------------------------------------
; initial "headers" for booting
;---------------------------------------------------------

	section .text		; keep all code and data in text seg

	bits 16			; 16-bit real mode
	org 0			; start at offset 0 (sector 0)

	jmp main		; jump to the start (main part) of code


%include "data.inc"		; has all the main data types used here
%include "data1.inc"		; has local function types

;---------------------------------------------------------
; start of the code
;---------------------------------------------------------

main:
	mov [bootnum],dl	; save boot drive in bootnum

	jmp short setsys	; set up the segments & stacks
				; we still need to jmp until we set the
				; stack.. then we can start 'call'ing
				; to make the code clearer (although it may
				; be a little slower to call)

main1:
	call clearscreen	; clear screen through mode 3 video int
	call printbootmsgs	; output the bootup messages

	call test386		; make sure we have at least a 386

	jmp loadsectors		; load the 2nd stage loader into 0x10000

	; shouldn't ever get to here
	jmp halt

%include "sys.asm"		; setup segments and stack
%include "halt.asm"		; halt/reboot functions
%include "print.asm"		; video/print/output functions
%include "sects.asm"		; sector manipulating functions
%include "keyboard.asm"		; keyboard functions


;--------------------------------------------------------
; this is the end of the file (includes boot signature)
;--------------------------------------------------------

times 510-($-$$) db 0		; nasm's way of doing 'org 510'
				; this also ensure that the rest of the boot
				; sector is clean/empty (null)

dw BOOTSIG			; boot signature (ie magic number)
