; this file includes functions to manipulate the sectors
; ------------------------------------------------------

;---------------------------------------------------------
; load sector 2 off the boot drive (2nd loader location)
;---------------------------------------------------------

loadsectors:
	xor ax,ax		; function 00h (init drive)
	xor dx,dx		; drive 0

	clc			; clear the carry flag
	int 13h

	jc failure

	; ----------------------------------------

	mov ah,2		; 2 = read sectors function
	mov al,4		; # of sectors to read
				; (2nd stage boot loader = 2k)

	mov ch,0		; cylinder #
	mov cl,2		; sector # to read

	xor dx,dx		; empty/clear out edx

	mov dh,0		; dh = head #
	mov dl,0		; boot drive

	; ----------------------------------------

	; setup segment:offset
	mov bx,NEWSEG		; load 2nd stage loader to 1000:0000
	mov es,bx		; set es to above address

	xor bx,bx		; set offset to 0000

	; ---------------------------------------------

	clc			; clear the carry flag

	int 13h
	jc failure

	call getkey
	call clearscreen

	mov ax,NEWSEG		; set all segments to 1000:0000
	mov ds,ax
;	mov es,ax		; we just set it to NEWSEG above
	mov fs,ax
	mov gs,ax

	mov ax,NEWSTACKSEG

	cli
	mov ss,ax		; set new stack segment to 0x1050
	mov sp,STACKSIZE	; set stack size to 1000h (4k)
	sti

	jmp 1000h:0h

; ----------------------------------------------------

failure:
	mov si,sectreaderrmsg	; load the message into ds:si for printmsg
	call printmsg		; output the sector error message

	jmp halt		; halt the system
