; this file has functions to setup the system stacks/segments
; -----------------------------------------------------------

;---------------------------------------------------------
; setup the stack and the like
;---------------------------------------------------------

setsys:
	; this sets up segments to where our boot sector is (0000:7c00h)
	; bios reads the boot sector from disk and loads it into 7c00h

	; another thing we could have done would be to xor ax,ax
	; and set up all the segments as 0 for now, and used just sp


	mov ax,BOOTSEG		; bootseg = where bios loads mem
	mov ds,ax		; setup all the segments
	mov es,ax
	mov fs,ax
	mov gs,ax

	mov ax,STACKSEG

	cli			; disable interrupts
	mov ss,ax		; set ss to 0x800
	mov sp,STACKSIZE	; set stack size to 1000h (4k)
	sti			; restore old interrupts

	jmp short main1		; return to main again


;---------------------------------------------------------
; check to make sure we're at least running a 386
;---------------------------------------------------------

test386:
	pushf			; save old flags

	xor ah,ah		; clear/empty high byte of ax
	push ax			; push the value of ax onto the stack..
	popf			; and pop that into flags register
				; (flags = push'd value of ax)

	; now high nibble is empty (if it wasn't)..
	; try to set ceratain bits ourselves..
	; if we can't then it's < 386

	pushf			; push flags on the stack..
	pop ax			; and pop that into ax (so we can modify it)

        and ah, 0f0h		; try to set the high nibble
	cmp ah, 0f0h		; on a 386, the high nibble can't be 0f0h
 
	jne short .done		; restore flags and return (it's >= 386)

	popf			; restore original flags

	pushf			; save original flags again

	mov ah, 70h		; now try to set NT and IOPL

	push ax
	popf

	pushf
	pop ax

	and ah, 70h		; if fails, no 386 is installed
	jnz short .done		; restore flags and return (it's >= 386)

	mov si,no386msg		; put message into ds:si for printmsg
	call printmsg		; print the no386 msg

	call getkey		; wait for user to hit a key
	call halt		; halt the computer

.done:
	popf			; restore flags
	ret
