; basic protected mode structures
;--------------------------------

; the segment descriptor
struc segdesc
	.length    resw 1	; low word of the segment length
	.baseaddr1 resw 1	; low word of base address
	.baseaddr2 resb 1	; low byte of high word of base addr.
	.flags     resb 1	; segment type and misc. flags
	.access    resb 1	; highest nibble of seg len & access flags
	.baseaddr3 resb 1	; highest byte of base address
endstruc

; ---------------------------------------

; the interrupt descriptor
struc intdesc
	.offset   resw 1	; low word of handler offset
	.selector resw 1	; segment selector
	.nullbyte resb 1	; unused in this descriptor format
	.flags    resb 1	; flag-byte
	.offset1  resw 1	; high-word of handler offset
endstruc
