; This is the 2nd stage boot loader for w00os
;
; Developed by Matt Conover and the w00brothers
; See http://www.w00w00.org (WSD)
;
; It is loaded into 1000h:0000 (0x10000) by the 1st stage boot loader
; This should be put in sector 2 of the floppy disk
;

	section .text		; keep all code and data in text seg

	bits 16			; 16-bit real mode
	org 0			; start at offset 0 (sector 0)

	jmp main		; jump to the start (main part) of code


%include "data.inc"		; include shared data definitions
%include "data2.inc"		; include local (stage2) data definitions

%include "convert.inc"		; include definitions for conversions

%include "printreg.inc"		; include data to print registers
%include "printreg.mac"		; include macros to print registers

%include "pmode.inc"		; include data structures for pmode


;---------------------------------------------------------
; start of the code
;---------------------------------------------------------

main:
	; FIX - add it to print the address we're at too

	call clearscreen	; clear the screen

	mov si,stage2msg	; put the message into ds:si for printmsg
	call printmsg		; inform user we're in stage 2 loader

	call getkey

	; ------------------------------

	;push ax
	;mov ax,0x1234
	;print16reg ax
	;pop ax

	; ------------------------------

	call setinthandlers	; setup real mode interrupt handlers
	call setpmode		; put us in protected mode if we're not
				; (which we shouldn't be)

	; ------------------------------

;	call initkernel		; initialize the kernel structures
;	call _start		; jump into kernel

	jmp halt

; -------------------------------------------

%include "ints.asm"		; setup interrupt handlers
%include "pmode.asm"		; functions to check pmode, v86 mode, etc.
%include "convert.asm"		; functions that convert ascii/hex/int
%include "print.asm"		; functions involving printing to screen
%include "keyboard.asm"		; functions to get user input
%include "halt.asm"		; halt/reboot functions


times 2096-($-$$) db 0		; nasm's way of doing 'org 1024'
				; this also ensure that the rest of the boot
				; sector is clean/empty (null)
