;--------------------------------------------------
; convert an 16-bit int into 4 digit hex str
;--------------------------------------------------

; input: ax = 16-bit int
; output: es:bx = buffer to write the 4 digit hex str

int2hex:
	push ax		; save the old values
	push bx
	push cx

	add bx,4	; start es:bx at end of str and go backwards

	mov cx,4	; loop 4 times (4 digits)

.hexloop:
	and al,0Fh	; hex'ify the # (store only the low nibble)

	mov byte [es:bx],hexmap+al

	dec bx		; decrease pointer of string
	shr ax,4	; shift high nibble into low nibble

	loop .hexloop	; loop again if cx != 0

	pop cx	; restore the old values
	pop bx
	pop ax

	ret


;--------------------------------------------------
; convert an 8-bit int into 2 digit hex char
;--------------------------------------------------

; input: al = 8-bit int
; output: es:bx = buffer to write the 2 digit hex #

byte2hex:
	push ax			; save the old values
	push bx

	; ----- do high byte hex char -----

	push ax			; save the old value

	and al,0xf0		; set the high nibble
	shr al,4		; shift the high nib into the low nib

	mov byte [es:bx],hexmap+al	; output the character into the buf
	inc bx				; point bx to the next byte in buffer

	pop ax			; restore the old value

	; ----- do low byte hex char -----

	and al,0fh			; get hexchar out of low nibble
	mov byte [es:bx],hexmap+al	; output the 2nd hex char

	; --------------------------------

	pop bx			; save the old values
	pop ax

	ret


;--------------------------------------------------
; convert an 16-bit int into ascii 
; (2 digits, or 3 [the '-'] depending on sign)
;--------------------------------------------------

; intput: ax = 16-bit int
; output: ex:bx = ascii str

int2ascii:
	push ax			; save the old vlaue

	cmp ax,0		; compare ax value to 0
	jge .uint		; if it's >= 0 skip this part

	; it's a negative #

	mov byte [es:bx],'-'	; it's a negative #
	inc bx			; increase str pointer

	; the next 2 instructions switch the sign

	neg ax			; do the 2's complement to ax
	inc ax			; add 1

	pop ax			; restore old ax value
	call uint2ascii		; handle uint/int the same way now

.uint:	pop ax			; restore old ax 
	jmp uint2ascii		; now ascii'ify it

;--------------------------------------------------
; convert an 16-bit uint into ascii (4 digits)
;--------------------------------------------------

; intput: ax = 16-bit int
; output: ex:bx = ascii str

; note: used by both int and uint to do calculations

uint2ascii:        
	push ax			; save the old values
	push bx
	push cx

	mov cx,4		; 4 digits
	mov bx,4		; start bx at the end of the string

	.uintloop:
		push dx		; save the old value

		mov dl,10
		div dl		; ax / 10.. al = quotient, ah = remainder

		pop dx		; restore the old value

		push ax		; save old ax value
		add al,'0'	; ascii'ify it
		
		mov byte [es:bx],al	; copy the character into the buf
		dec bx			; decrease string pointer
		
		pop ax		; restore old ax value

		mov al,0	; clear/empty al
		xchg ah,al	; switch ah/al

	loop .uintloop		; loop again if cx != 0

	pop cx			; save the old values
	pop bx
	pop ax

	ret
