; this file contains functions to check things like protected mode
; v86 mode, and other system modes 
; ----------------------------------------------------------------


;-----------------------------------------------------
; set us in protected mode (if we aren't already)
;-----------------------------------------------------

setpmode:
	push eax		; save the old values

	mov eax, cr0		; get CR0 into EAX
	and al, 1		; check if PM bit is set

	jz short .done		; if it's not zero, it's set (in pmode)

	mov si,pmodemsg		; move message into ds:si for printmsg
	call printmsg		; print the "already in pmode" message

	call getkey		; wait for user input

	; ------------------------------------
	; put us in pmode

	pop eax			; restore old eax value
	ret


.done:
	pop eax			; restore the old vlaues
	ret
