/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NIS_H_RPCGEN
#define _NIS_H_RPCGEN

#include <rpc/rpc.h>

/*
 *	nis.h
 *
 *	This file is the main include file for NIS clients. It contains
 *	both the client library function defines and the various data
 * 	structures used by the NIS service. It includes the file nis_tags.h
 *	which defines the tag values. This allows the tags to change without
 *	having to change the nis.x file.
 * 	
 *	NOTE : DO NOT EDIT THIS FILE! It is automatically generated when
 *	       rpcgen is run on the nis.x file. Note that there is a 
 *	       simple sed script to remove some unneeded lines. (See the
 *	       Makefile target nis.h)
 *
 */
#include <rpcsvc/nis_tags.h>
#include <rpc/xdr.h>
#pragma ident	"@(#)nis_object.x	1.7	92/07/14 SMI"

#ifndef __nis_object_h
#define __nis_object_h

#define NIS_MAXSTRINGLEN 255
#define NIS_MAXNAMELEN 1024
#define NIS_MAXATTRNAME 32
#define NIS_MAXATTRVAL 2048
#define NIS_MAXCOLUMNS 64
#define NIS_MAXATTR 16
#define NIS_MAXPATH 1024
#define NIS_MAXREPLICAS 128
#define NIS_MAXLINKS 16
#define NIS_PK_NONE 0
#define NIS_PK_DH 1
#define NIS_PK_RSA 2
#define NIS_PK_KERB 3

struct nis_attr {
	char *zattr_ndx;
	struct {
		u_int zattr_val_len;
		char *zattr_val_val;
	} zattr_val;
};
typedef struct nis_attr nis_attr;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_attr(XDR *, nis_attr*);
#elif __STDC__ 
extern  bool_t xdr_nis_attr(XDR *, nis_attr*);
#else /* Old Style C */ 
bool_t xdr_nis_attr();
#endif /* Old Style C */ 


typedef char *nis_name;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_name(XDR *, nis_name*);
#elif __STDC__ 
extern  bool_t xdr_nis_name(XDR *, nis_name*);
#else /* Old Style C */ 
bool_t xdr_nis_name();
#endif /* Old Style C */ 


enum zotypes {
	BOGUS_OBJ = 0,
	NO_OBJ = 1,
	DIRECTORY_OBJ = 2,
	GROUP_OBJ = 3,
	TABLE_OBJ = 4,
	ENTRY_OBJ = 5,
	LINK_OBJ = 6,
	PRIVATE_OBJ = 7,
};
typedef enum zotypes zotypes;
#ifdef __cplusplus 
extern "C" bool_t xdr_zotypes(XDR *, zotypes*);
#elif __STDC__ 
extern  bool_t xdr_zotypes(XDR *, zotypes*);
#else /* Old Style C */ 
bool_t xdr_zotypes();
#endif /* Old Style C */ 


enum nstype {
	UNKNOWN = 0,
	NIS = 1,
	SUNYP = 2,
	IVY = 3,
	DNS = 4,
	X500 = 5,
	DNANS = 6,
	XCHS = 7,
	CDS = 8,
};
typedef enum nstype nstype;
#ifdef __cplusplus 
extern "C" bool_t xdr_nstype(XDR *, nstype*);
#elif __STDC__ 
extern  bool_t xdr_nstype(XDR *, nstype*);
#else /* Old Style C */ 
bool_t xdr_nstype();
#endif /* Old Style C */ 


struct oar_mask {
	u_long oa_rights;
	zotypes oa_otype;
};
typedef struct oar_mask oar_mask;
#ifdef __cplusplus 
extern "C" bool_t xdr_oar_mask(XDR *, oar_mask*);
#elif __STDC__ 
extern  bool_t xdr_oar_mask(XDR *, oar_mask*);
#else /* Old Style C */ 
bool_t xdr_oar_mask();
#endif /* Old Style C */ 


struct endpoint {
	char *uaddr;
	char *family;
	char *proto;
};
typedef struct endpoint endpoint;
#ifdef __cplusplus 
extern "C" bool_t xdr_endpoint(XDR *, endpoint*);
#elif __STDC__ 
extern  bool_t xdr_endpoint(XDR *, endpoint*);
#else /* Old Style C */ 
bool_t xdr_endpoint();
#endif /* Old Style C */ 


struct nis_server {
	nis_name name;
	struct {
		u_int ep_len;
		endpoint *ep_val;
	} ep;
	u_long key_type;
	netobj pkey;
};
typedef struct nis_server nis_server;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_server(XDR *, nis_server*);
#elif __STDC__ 
extern  bool_t xdr_nis_server(XDR *, nis_server*);
#else /* Old Style C */ 
bool_t xdr_nis_server();
#endif /* Old Style C */ 


struct directory_obj {
	nis_name do_name;
	nstype do_type;
	struct {
		u_int do_servers_len;
		nis_server *do_servers_val;
	} do_servers;
	u_long do_ttl;
	struct {
		u_int do_armask_len;
		oar_mask *do_armask_val;
	} do_armask;
};
typedef struct directory_obj directory_obj;
#ifdef __cplusplus 
extern "C" bool_t xdr_directory_obj(XDR *, directory_obj*);
#elif __STDC__ 
extern  bool_t xdr_directory_obj(XDR *, directory_obj*);
#else /* Old Style C */ 
bool_t xdr_directory_obj();
#endif /* Old Style C */ 

#define EN_BINARY 1
#define EN_CRYPT 2
#define EN_XDR 4
#define EN_MODIFIED 8
#define EN_ASN1 64

struct entry_col {
	u_long ec_flags;
	struct {
		u_int ec_value_len;
		char *ec_value_val;
	} ec_value;
};
typedef struct entry_col entry_col;
#ifdef __cplusplus 
extern "C" bool_t xdr_entry_col(XDR *, entry_col*);
#elif __STDC__ 
extern  bool_t xdr_entry_col(XDR *, entry_col*);
#else /* Old Style C */ 
bool_t xdr_entry_col();
#endif /* Old Style C */ 


struct entry_obj {
	char *en_type;
	struct {
		u_int en_cols_len;
		entry_col *en_cols_val;
	} en_cols;
};
typedef struct entry_obj entry_obj;
#ifdef __cplusplus 
extern "C" bool_t xdr_entry_obj(XDR *, entry_obj*);
#elif __STDC__ 
extern  bool_t xdr_entry_obj(XDR *, entry_obj*);
#else /* Old Style C */ 
bool_t xdr_entry_obj();
#endif /* Old Style C */ 


struct group_obj {
	u_long gr_flags;
	struct {
		u_int gr_members_len;
		nis_name *gr_members_val;
	} gr_members;
};
typedef struct group_obj group_obj;
#ifdef __cplusplus 
extern "C" bool_t xdr_group_obj(XDR *, group_obj*);
#elif __STDC__ 
extern  bool_t xdr_group_obj(XDR *, group_obj*);
#else /* Old Style C */ 
bool_t xdr_group_obj();
#endif /* Old Style C */ 


struct link_obj {
	zotypes li_rtype;
	struct {
		u_int li_attrs_len;
		nis_attr *li_attrs_val;
	} li_attrs;
	nis_name li_name;
};
typedef struct link_obj link_obj;
#ifdef __cplusplus 
extern "C" bool_t xdr_link_obj(XDR *, link_obj*);
#elif __STDC__ 
extern  bool_t xdr_link_obj(XDR *, link_obj*);
#else /* Old Style C */ 
bool_t xdr_link_obj();
#endif /* Old Style C */ 

#define TA_BINARY 1
#define TA_CRYPT 2
#define TA_XDR 4
#define TA_SEARCHABLE 8
#define TA_CASE 16
#define TA_MODIFIED 32
#define TA_ASN1 64

struct table_col {
	char *tc_name;
	u_long tc_flags;
	u_long tc_rights;
};
typedef struct table_col table_col;
#ifdef __cplusplus 
extern "C" bool_t xdr_table_col(XDR *, table_col*);
#elif __STDC__ 
extern  bool_t xdr_table_col(XDR *, table_col*);
#else /* Old Style C */ 
bool_t xdr_table_col();
#endif /* Old Style C */ 


struct table_obj {
	char *ta_type;
	int ta_maxcol;
	u_char ta_sep;
	struct {
		u_int ta_cols_len;
		table_col *ta_cols_val;
	} ta_cols;
	char *ta_path;
};
typedef struct table_obj table_obj;
#ifdef __cplusplus 
extern "C" bool_t xdr_table_obj(XDR *, table_obj*);
#elif __STDC__ 
extern  bool_t xdr_table_obj(XDR *, table_obj*);
#else /* Old Style C */ 
bool_t xdr_table_obj();
#endif /* Old Style C */ 


struct objdata {
	zotypes zo_type;
	union {
		struct directory_obj di_data;
		struct group_obj gr_data;
		struct table_obj ta_data;
		struct entry_obj en_data;
		struct link_obj li_data;
		struct {
			u_int po_data_len;
			char *po_data_val;
		} po_data;
	} objdata_u;
};
typedef struct objdata objdata;
#ifdef __cplusplus 
extern "C" bool_t xdr_objdata(XDR *, objdata*);
#elif __STDC__ 
extern  bool_t xdr_objdata(XDR *, objdata*);
#else /* Old Style C */ 
bool_t xdr_objdata();
#endif /* Old Style C */ 


struct nis_oid {
	u_long ctime;
	u_long mtime;
};
typedef struct nis_oid nis_oid;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_oid(XDR *, nis_oid*);
#elif __STDC__ 
extern  bool_t xdr_nis_oid(XDR *, nis_oid*);
#else /* Old Style C */ 
bool_t xdr_nis_oid();
#endif /* Old Style C */ 


struct nis_object {
	nis_oid zo_oid;
	nis_name zo_name;
	nis_name zo_owner;
	nis_name zo_group;
	nis_name zo_domain;
	u_long zo_access;
	u_long zo_ttl;
	objdata zo_data;
};
typedef struct nis_object nis_object;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_object(XDR *, nis_object*);
#elif __STDC__ 
extern  bool_t xdr_nis_object(XDR *, nis_object*);
#else /* Old Style C */ 
bool_t xdr_nis_object();
#endif /* Old Style C */ 


#endif /* if __nis_object_h */


enum nis_error {
	NIS_SUCCESS = 0,
	NIS_S_SUCCESS = 1,
	NIS_NOTFOUND = 2,
	NIS_S_NOTFOUND = 3,
	NIS_CACHEEXPIRED = 4,
	NIS_NAMEUNREACHABLE = 5,
	NIS_UNKNOWNOBJ = 6,
	NIS_TRYAGAIN = 7,
	NIS_SYSTEMERROR = 8,
	NIS_CHAINBROKEN = 9,
	NIS_PERMISSION = 10,
	NIS_NOTOWNER = 11,
	NIS_NOT_ME = 12,
	NIS_NOMEMORY = 13,
	NIS_NAMEEXISTS = 14,
	NIS_NOTMASTER = 15,
	NIS_INVALIDOBJ = 16,
	NIS_BADNAME = 17,
	NIS_NOCALLBACK = 18,
	NIS_CBRESULTS = 19,
	NIS_NOSUCHNAME = 20,
	NIS_NOTUNIQUE = 21,
	NIS_IBMODERROR = 22,
	NIS_NOSUCHTABLE = 23,
	NIS_TYPEMISMATCH = 24,
	NIS_LINKNAMEERROR = 25,
	NIS_PARTIAL = 26,
	NIS_TOOMANYATTRS = 27,
	NIS_RPCERROR = 28,
	NIS_BADATTRIBUTE = 29,
	NIS_NOTSEARCHABLE = 30,
	NIS_CBERROR = 31,
	NIS_FOREIGNNS = 32,
	NIS_BADOBJECT = 33,
	NIS_NOTSAMEOBJ = 34,
	NIS_MODFAIL = 35,
	NIS_BADREQUEST = 36,
	NIS_NOTEMPTY = 37,
	NIS_COLDSTART_ERR = 38,
	NIS_RESYNC = 39,
	NIS_FAIL = 40,
	NIS_UNAVAIL = 41,
	NIS_RES2BIG = 42,
	NIS_SRVAUTH = 43,
	NIS_CLNTAUTH = 44,
	NIS_NOFILESPACE = 45,
	NIS_NOPROC = 46,
	NIS_DUMPLATER = 47,
};
typedef enum nis_error nis_error;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_error(XDR *, nis_error*);
#elif __STDC__ 
extern  bool_t xdr_nis_error(XDR *, nis_error*);
#else /* Old Style C */ 
bool_t xdr_nis_error();
#endif /* Old Style C */ 


struct nis_result {
	nis_error status;
	struct {
		u_int objects_len;
		nis_object *objects_val;
	} objects;
	netobj cookie;
	u_long zticks;
	u_long dticks;
	u_long aticks;
	u_long cticks;
};
typedef struct nis_result nis_result;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_result(XDR *, nis_result*);
#elif __STDC__ 
extern  bool_t xdr_nis_result(XDR *, nis_result*);
#else /* Old Style C */ 
bool_t xdr_nis_result();
#endif /* Old Style C */ 


struct ns_request {
	nis_name ns_name;
	struct {
		u_int ns_object_len;
		nis_object *ns_object_val;
	} ns_object;
};
typedef struct ns_request ns_request;
#ifdef __cplusplus 
extern "C" bool_t xdr_ns_request(XDR *, ns_request*);
#elif __STDC__ 
extern  bool_t xdr_ns_request(XDR *, ns_request*);
#else /* Old Style C */ 
bool_t xdr_ns_request();
#endif /* Old Style C */ 


struct ib_request {
	nis_name ibr_name;
	struct {
		u_int ibr_srch_len;
		nis_attr *ibr_srch_val;
	} ibr_srch;
	u_long ibr_flags;
	struct {
		u_int ibr_obj_len;
		nis_object *ibr_obj_val;
	} ibr_obj;
	struct {
		u_int ibr_cbhost_len;
		nis_server *ibr_cbhost_val;
	} ibr_cbhost;
	u_long ibr_bufsize;
	netobj ibr_cookie;
};
typedef struct ib_request ib_request;
#ifdef __cplusplus 
extern "C" bool_t xdr_ib_request(XDR *, ib_request*);
#elif __STDC__ 
extern  bool_t xdr_ib_request(XDR *, ib_request*);
#else /* Old Style C */ 
bool_t xdr_ib_request();
#endif /* Old Style C */ 


struct ping_args {
	nis_name dir;
	u_long stamp;
};
typedef struct ping_args ping_args;
#ifdef __cplusplus 
extern "C" bool_t xdr_ping_args(XDR *, ping_args*);
#elif __STDC__ 
extern  bool_t xdr_ping_args(XDR *, ping_args*);
#else /* Old Style C */ 
bool_t xdr_ping_args();
#endif /* Old Style C */ 


enum log_entry_t {
	LOG_NOP = 0,
	ADD_NAME = 1,
	REM_NAME = 2,
	MOD_NAME_OLD = 3,
	MOD_NAME_NEW = 4,
	ADD_IBASE = 5,
	REM_IBASE = 6,
	MOD_IBASE = 7,
	UPD_STAMP = 8,
};
typedef enum log_entry_t log_entry_t;
#ifdef __cplusplus 
extern "C" bool_t xdr_log_entry_t(XDR *, log_entry_t*);
#elif __STDC__ 
extern  bool_t xdr_log_entry_t(XDR *, log_entry_t*);
#else /* Old Style C */ 
bool_t xdr_log_entry_t();
#endif /* Old Style C */ 


struct log_entry {
	u_long le_time;
	log_entry_t le_type;
	nis_name le_princp;
	nis_name le_name;
	struct {
		u_int le_attrs_len;
		nis_attr *le_attrs_val;
	} le_attrs;
	nis_object le_object;
};
typedef struct log_entry log_entry;
#ifdef __cplusplus 
extern "C" bool_t xdr_log_entry(XDR *, log_entry*);
#elif __STDC__ 
extern  bool_t xdr_log_entry(XDR *, log_entry*);
#else /* Old Style C */ 
bool_t xdr_log_entry();
#endif /* Old Style C */ 


struct log_result {
	nis_error lr_status;
	netobj lr_cookie;
	struct {
		u_int lr_entries_len;
		log_entry *lr_entries_val;
	} lr_entries;
};
typedef struct log_result log_result;
#ifdef __cplusplus 
extern "C" bool_t xdr_log_result(XDR *, log_result*);
#elif __STDC__ 
extern  bool_t xdr_log_result(XDR *, log_result*);
#else /* Old Style C */ 
bool_t xdr_log_result();
#endif /* Old Style C */ 


struct cp_result {
	nis_error cp_status;
	u_long cp_zticks;
	u_long cp_dticks;
};
typedef struct cp_result cp_result;
#ifdef __cplusplus 
extern "C" bool_t xdr_cp_result(XDR *, cp_result*);
#elif __STDC__ 
extern  bool_t xdr_cp_result(XDR *, cp_result*);
#else /* Old Style C */ 
bool_t xdr_cp_result();
#endif /* Old Style C */ 


struct nis_tag {
	u_long tag_type;
	char *tag_val;
};
typedef struct nis_tag nis_tag;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_tag(XDR *, nis_tag*);
#elif __STDC__ 
extern  bool_t xdr_nis_tag(XDR *, nis_tag*);
#else /* Old Style C */ 
bool_t xdr_nis_tag();
#endif /* Old Style C */ 


struct nis_taglist {
	struct {
		u_int tags_len;
		nis_tag *tags_val;
	} tags;
};
typedef struct nis_taglist nis_taglist;
#ifdef __cplusplus 
extern "C" bool_t xdr_nis_taglist(XDR *, nis_taglist*);
#elif __STDC__ 
extern  bool_t xdr_nis_taglist(XDR *, nis_taglist*);
#else /* Old Style C */ 
bool_t xdr_nis_taglist();
#endif /* Old Style C */ 


struct dump_args {
	nis_name da_dir;
	u_long da_time;
	struct {
		u_int da_cbhost_len;
		nis_server *da_cbhost_val;
	} da_cbhost;
};
typedef struct dump_args dump_args;
#ifdef __cplusplus 
extern "C" bool_t xdr_dump_args(XDR *, dump_args*);
#elif __STDC__ 
extern  bool_t xdr_dump_args(XDR *, dump_args*);
#else /* Old Style C */ 
bool_t xdr_dump_args();
#endif /* Old Style C */ 


struct fd_args {
	nis_name dir_name;
	nis_name requester;
};
typedef struct fd_args fd_args;
#ifdef __cplusplus 
extern "C" bool_t xdr_fd_args(XDR *, fd_args*);
#elif __STDC__ 
extern  bool_t xdr_fd_args(XDR *, fd_args*);
#else /* Old Style C */ 
bool_t xdr_fd_args();
#endif /* Old Style C */ 


struct fd_result {
	nis_error status;
	nis_name source;
	struct {
		u_int dir_data_len;
		char *dir_data_val;
	} dir_data;
	struct {
		u_int signature_len;
		char *signature_val;
	} signature;
};
typedef struct fd_result fd_result;
#ifdef __cplusplus 
extern "C" bool_t xdr_fd_result(XDR *, fd_result*);
#elif __STDC__ 
extern  bool_t xdr_fd_result(XDR *, fd_result*);
#else /* Old Style C */ 
bool_t xdr_fd_result();
#endif /* Old Style C */ 

/*
 * Generic "hash" datastructures, used by all types of hashed data.
 */
struct nis_hash_data {
	nis_name		name;	   /* NIS name of hashed item      */
	int			keychain;  /* It's hash key (for pop)      */
	struct nis_hash_data	*next;	   /* Hash collision pointer       */
	struct nis_hash_data	*prv_item; /* A serial, doubly linked list */
	struct nis_hash_data	*nxt_item; /* of items in the hash table   */
};
typedef struct nis_hash_data NIS_HASH_ITEM;

struct nis_hash_table {
	NIS_HASH_ITEM	*keys[64];	/* A hash table of items           */
	NIS_HASH_ITEM	*first;		/* The first "item" in serial list */
};
typedef struct nis_hash_table NIS_HASH_TABLE;

/* Structure for storing dynamically allocated static data */
struct nis_sdata {
	void	*buf;	/* Memory allocation pointer 	*/
	u_long	size;	/* Buffer size			*/
};

/* Generic client creating flags */
#define ZMH_VC		1
#define ZMH_DG		2
#define ZMH_AUTH	4

/* Testing Access rights for objects */

#define NIS_READ_ACC		1
#define NIS_MODIFY_ACC		2
#define NIS_CREATE_ACC		4
#define NIS_DESTROY_ACC	8
/* Test macros. a == access rights, m == desired rights. */
#define WORLD(a, m)	(((a) & (m)) != 0)
#define GROUP(a, m)	(((a) & ((m) << 8)) != 0)
#define OWNER(a, m)	(((a) & ((m) << 16)) != 0)
#define NOBODY(a, m)	(((a) & ((m) << 24)) != 0)

#define OATYPE(d, n) (((d)->do_armask.do_armask_val+n)->oa_otype)
#define OARIGHTS(d, n) (((d)->do_armask.do_armask_val+n)->oa_rights)
#define WORLD_DEFAULT (NIS_READ_ACC)
#define GROUP_DEFAULT (NIS_READ_ACC << 8)
#define OWNER_DEFAULT ((NIS_READ_ACC +%			 NIS_MODIFY_ACC +%			 NIS_CREATE_ACC +%			 NIS_DESTROY_ACC) << 16)
#define DEFAULT_RIGHTS (WORLD_DEFAULT | GROUP_DEFAULT | OWNER_DEFAULT)

/* Result manipulation defines ... */
#define NIS_RES_NUMOBJ(x)	((x)->objects.objects_len)
#define NIS_RES_OBJECT(x)	((x)->objects.objects_val)
#define NIS_RES_COOKIE(x)	((x)->cookie)
#define NIS_RES_STATUS(x)	((x)->status)

/* These defines make getting at the variant part of the object easier. */
#define TA_data zo_data.objdata_u.ta_data
#define EN_data zo_data.objdata_u.en_data
#define DI_data zo_data.objdata_u.di_data
#define LI_data zo_data.objdata_u.li_data
#define GR_data zo_data.objdata_u.gr_data

#define __type_of(o) ((o)->zo_data.zo_type)

/* Declarations for the internal subroutines in nislib.c */
enum name_pos {SAME_NAME, HIGHER_NAME, LOWER_NAME, NOT_SEQUENTIAL, BAD_NAME};
typedef enum name_pos name_pos;

/*
 * Defines for getting at column data in entry objects. Because RPCGEN
 * generates some rather wordy structures, we create some defines that
 * collapse the needed keystrokes to access a particular value using
 * these definitions they take an nis_object *, and an int and return
 * a u_char * for Value, and an int for length.
 */
#define ENTRY_VAL(obj, col) %	(obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_val
#define ENTRY_LEN(obj, col) %	(obj)->EN_data.en_cols.en_cols_val[col].ec_value.ec_value_len

#ifdef __cplusplus
}
#endif

/* Prototypes, and extern declarations for the NIS library functions. */
#include <rpcsvc/nislib.h>
#endif /* __NIS_RPCGEN_H */
/* EDIT_START */

/*
 * nis_3.h
 * 
 * This file contains definitions that are only of interest to the actual
 * service daemon and client stubs. Normal users of NIS will not include
 * this file.
 *
 * NOTE : This include file is automatically created by a combination 
 * of rpcgen and sed. DO NOT EDIT IT, change the nis.x file instead
 * and then remake this file.
 */
#ifndef __nis_3_h
#define __nis_3_h
#ifdef __cplusplus
extern "C" {
#endif

#define NIS_PROG ((u_long)100300)
#define NIS_VERSION ((u_long)3)

#ifdef __cplusplus
#define NIS_LOOKUP ((u_long)1)
extern "C" nis_result * nis_lookup_3(ns_request *, CLIENT *);
extern "C" nis_result * nis_lookup_3_svc(ns_request *, struct svc_req *);
#define NIS_ADD ((u_long)2)
extern "C" nis_result * nis_add_3(ns_request *, CLIENT *);
extern "C" nis_result * nis_add_3_svc(ns_request *, struct svc_req *);
#define NIS_MODIFY ((u_long)3)
extern "C" nis_result * nis_modify_3(ns_request *, CLIENT *);
extern "C" nis_result * nis_modify_3_svc(ns_request *, struct svc_req *);
#define NIS_REMOVE ((u_long)4)
extern "C" nis_result * nis_remove_3(ns_request *, CLIENT *);
extern "C" nis_result * nis_remove_3_svc(ns_request *, struct svc_req *);
#define NIS_IBLIST ((u_long)5)
extern "C" nis_result * nis_iblist_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_iblist_3_svc(ib_request *, struct svc_req *);
#define NIS_IBADD ((u_long)6)
extern "C" nis_result * nis_ibadd_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_ibadd_3_svc(ib_request *, struct svc_req *);
#define NIS_IBMODIFY ((u_long)7)
extern "C" nis_result * nis_ibmodify_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_ibmodify_3_svc(ib_request *, struct svc_req *);
#define NIS_IBREMOVE ((u_long)8)
extern "C" nis_result * nis_ibremove_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_ibremove_3_svc(ib_request *, struct svc_req *);
#define NIS_IBFIRST ((u_long)9)
extern "C" nis_result * nis_ibfirst_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_ibfirst_3_svc(ib_request *, struct svc_req *);
#define NIS_IBNEXT ((u_long)10)
extern "C" nis_result * nis_ibnext_3(ib_request *, CLIENT *);
extern "C" nis_result * nis_ibnext_3_svc(ib_request *, struct svc_req *);
#define NIS_FINDDIRECTORY ((u_long)12)
extern "C" fd_result * nis_finddirectory_3(fd_args *, CLIENT *);
extern "C" fd_result * nis_finddirectory_3_svc(fd_args *, struct svc_req *);
#define NIS_STATUS ((u_long)14)
extern "C" nis_taglist * nis_status_3(nis_taglist *, CLIENT *);
extern "C" nis_taglist * nis_status_3_svc(nis_taglist *, struct svc_req *);
#define NIS_DUMPLOG ((u_long)15)
extern "C" log_result * nis_dumplog_3(dump_args *, CLIENT *);
extern "C" log_result * nis_dumplog_3_svc(dump_args *, struct svc_req *);
#define NIS_DUMP ((u_long)16)
extern "C" log_result * nis_dump_3(dump_args *, CLIENT *);
extern "C" log_result * nis_dump_3_svc(dump_args *, struct svc_req *);
#define NIS_CALLBACK ((u_long)17)
extern "C" bool_t * nis_callback_3(netobj *, CLIENT *);
extern "C" bool_t * nis_callback_3_svc(netobj *, struct svc_req *);
#define NIS_CPTIME ((u_long)18)
extern "C" u_long * nis_cptime_3(nis_name *, CLIENT *);
extern "C" u_long * nis_cptime_3_svc(nis_name *, struct svc_req *);
#define NIS_CHECKPOINT ((u_long)19)
extern "C" cp_result * nis_checkpoint_3(nis_name *, CLIENT *);
extern "C" cp_result * nis_checkpoint_3_svc(nis_name *, struct svc_req *);
#define NIS_PING ((u_long)20)
extern "C" void * nis_ping_3(ping_args *, CLIENT *);
extern "C" void * nis_ping_3_svc(ping_args *, struct svc_req *);
#define NIS_SERVSTATE ((u_long)21)
extern "C" nis_taglist * nis_servstate_3(nis_taglist *, CLIENT *);
extern "C" nis_taglist * nis_servstate_3_svc(nis_taglist *, struct svc_req *);
#define NIS_MKDIR ((u_long)22)
extern "C" nis_error * nis_mkdir_3(nis_name *, CLIENT *);
extern "C" nis_error * nis_mkdir_3_svc(nis_name *, struct svc_req *);
#define NIS_RMDIR ((u_long)23)
extern "C" nis_error * nis_rmdir_3(nis_name *, CLIENT *);
extern "C" nis_error * nis_rmdir_3_svc(nis_name *, struct svc_req *);
#define NIS_UPDKEYS ((u_long)24)
extern "C" nis_error * nis_updkeys_3(nis_name *, CLIENT *);
extern "C" nis_error * nis_updkeys_3_svc(nis_name *, struct svc_req *);

#elif __STDC__
#define NIS_LOOKUP ((u_long)1)
extern  nis_result * nis_lookup_3(ns_request *, CLIENT *);
extern  nis_result * nis_lookup_3_svc(ns_request *, struct svc_req *);
#define NIS_ADD ((u_long)2)
extern  nis_result * nis_add_3(ns_request *, CLIENT *);
extern  nis_result * nis_add_3_svc(ns_request *, struct svc_req *);
#define NIS_MODIFY ((u_long)3)
extern  nis_result * nis_modify_3(ns_request *, CLIENT *);
extern  nis_result * nis_modify_3_svc(ns_request *, struct svc_req *);
#define NIS_REMOVE ((u_long)4)
extern  nis_result * nis_remove_3(ns_request *, CLIENT *);
extern  nis_result * nis_remove_3_svc(ns_request *, struct svc_req *);
#define NIS_IBLIST ((u_long)5)
extern  nis_result * nis_iblist_3(ib_request *, CLIENT *);
extern  nis_result * nis_iblist_3_svc(ib_request *, struct svc_req *);
#define NIS_IBADD ((u_long)6)
extern  nis_result * nis_ibadd_3(ib_request *, CLIENT *);
extern  nis_result * nis_ibadd_3_svc(ib_request *, struct svc_req *);
#define NIS_IBMODIFY ((u_long)7)
extern  nis_result * nis_ibmodify_3(ib_request *, CLIENT *);
extern  nis_result * nis_ibmodify_3_svc(ib_request *, struct svc_req *);
#define NIS_IBREMOVE ((u_long)8)
extern  nis_result * nis_ibremove_3(ib_request *, CLIENT *);
extern  nis_result * nis_ibremove_3_svc(ib_request *, struct svc_req *);
#define NIS_IBFIRST ((u_long)9)
extern  nis_result * nis_ibfirst_3(ib_request *, CLIENT *);
extern  nis_result * nis_ibfirst_3_svc(ib_request *, struct svc_req *);
#define NIS_IBNEXT ((u_long)10)
extern  nis_result * nis_ibnext_3(ib_request *, CLIENT *);
extern  nis_result * nis_ibnext_3_svc(ib_request *, struct svc_req *);
#define NIS_FINDDIRECTORY ((u_long)12)
extern  fd_result * nis_finddirectory_3(fd_args *, CLIENT *);
extern  fd_result * nis_finddirectory_3_svc(fd_args *, struct svc_req *);
#define NIS_STATUS ((u_long)14)
extern  nis_taglist * nis_status_3(nis_taglist *, CLIENT *);
extern  nis_taglist * nis_status_3_svc(nis_taglist *, struct svc_req *);
#define NIS_DUMPLOG ((u_long)15)
extern  log_result * nis_dumplog_3(dump_args *, CLIENT *);
extern  log_result * nis_dumplog_3_svc(dump_args *, struct svc_req *);
#define NIS_DUMP ((u_long)16)
extern  log_result * nis_dump_3(dump_args *, CLIENT *);
extern  log_result * nis_dump_3_svc(dump_args *, struct svc_req *);
#define NIS_CALLBACK ((u_long)17)
extern  bool_t * nis_callback_3(netobj *, CLIENT *);
extern  bool_t * nis_callback_3_svc(netobj *, struct svc_req *);
#define NIS_CPTIME ((u_long)18)
extern  u_long * nis_cptime_3(nis_name *, CLIENT *);
extern  u_long * nis_cptime_3_svc(nis_name *, struct svc_req *);
#define NIS_CHECKPOINT ((u_long)19)
extern  cp_result * nis_checkpoint_3(nis_name *, CLIENT *);
extern  cp_result * nis_checkpoint_3_svc(nis_name *, struct svc_req *);
#define NIS_PING ((u_long)20)
extern  void * nis_ping_3(ping_args *, CLIENT *);
extern  void * nis_ping_3_svc(ping_args *, struct svc_req *);
#define NIS_SERVSTATE ((u_long)21)
extern  nis_taglist * nis_servstate_3(nis_taglist *, CLIENT *);
extern  nis_taglist * nis_servstate_3_svc(nis_taglist *, struct svc_req *);
#define NIS_MKDIR ((u_long)22)
extern  nis_error * nis_mkdir_3(nis_name *, CLIENT *);
extern  nis_error * nis_mkdir_3_svc(nis_name *, struct svc_req *);
#define NIS_RMDIR ((u_long)23)
extern  nis_error * nis_rmdir_3(nis_name *, CLIENT *);
extern  nis_error * nis_rmdir_3_svc(nis_name *, struct svc_req *);
#define NIS_UPDKEYS ((u_long)24)
extern  nis_error * nis_updkeys_3(nis_name *, CLIENT *);
extern  nis_error * nis_updkeys_3_svc(nis_name *, struct svc_req *);

#else /* Old Style C */ 
#define NIS_LOOKUP ((u_long)1)
extern  nis_result * nis_lookup_3();
extern  nis_result * nis_lookup_3_svc();
#define NIS_ADD ((u_long)2)
extern  nis_result * nis_add_3();
extern  nis_result * nis_add_3_svc();
#define NIS_MODIFY ((u_long)3)
extern  nis_result * nis_modify_3();
extern  nis_result * nis_modify_3_svc();
#define NIS_REMOVE ((u_long)4)
extern  nis_result * nis_remove_3();
extern  nis_result * nis_remove_3_svc();
#define NIS_IBLIST ((u_long)5)
extern  nis_result * nis_iblist_3();
extern  nis_result * nis_iblist_3_svc();
#define NIS_IBADD ((u_long)6)
extern  nis_result * nis_ibadd_3();
extern  nis_result * nis_ibadd_3_svc();
#define NIS_IBMODIFY ((u_long)7)
extern  nis_result * nis_ibmodify_3();
extern  nis_result * nis_ibmodify_3_svc();
#define NIS_IBREMOVE ((u_long)8)
extern  nis_result * nis_ibremove_3();
extern  nis_result * nis_ibremove_3_svc();
#define NIS_IBFIRST ((u_long)9)
extern  nis_result * nis_ibfirst_3();
extern  nis_result * nis_ibfirst_3_svc();
#define NIS_IBNEXT ((u_long)10)
extern  nis_result * nis_ibnext_3();
extern  nis_result * nis_ibnext_3_svc();
#define NIS_FINDDIRECTORY ((u_long)12)
extern  fd_result * nis_finddirectory_3();
extern  fd_result * nis_finddirectory_3_svc();
#define NIS_STATUS ((u_long)14)
extern  nis_taglist * nis_status_3();
extern  nis_taglist * nis_status_3_svc();
#define NIS_DUMPLOG ((u_long)15)
extern  log_result * nis_dumplog_3();
extern  log_result * nis_dumplog_3_svc();
#define NIS_DUMP ((u_long)16)
extern  log_result * nis_dump_3();
extern  log_result * nis_dump_3_svc();
#define NIS_CALLBACK ((u_long)17)
extern  bool_t * nis_callback_3();
extern  bool_t * nis_callback_3_svc();
#define NIS_CPTIME ((u_long)18)
extern  u_long * nis_cptime_3();
extern  u_long * nis_cptime_3_svc();
#define NIS_CHECKPOINT ((u_long)19)
extern  cp_result * nis_checkpoint_3();
extern  cp_result * nis_checkpoint_3_svc();
#define NIS_PING ((u_long)20)
extern  void * nis_ping_3();
extern  void * nis_ping_3_svc();
#define NIS_SERVSTATE ((u_long)21)
extern  nis_taglist * nis_servstate_3();
extern  nis_taglist * nis_servstate_3_svc();
#define NIS_MKDIR ((u_long)22)
extern  nis_error * nis_mkdir_3();
extern  nis_error * nis_mkdir_3_svc();
#define NIS_RMDIR ((u_long)23)
extern  nis_error * nis_rmdir_3();
extern  nis_error * nis_rmdir_3_svc();
#define NIS_UPDKEYS ((u_long)24)
extern  nis_error * nis_updkeys_3();
extern  nis_error * nis_updkeys_3_svc();
#endif /* Old Style C */ 

#endif /* !_NIS_H_RPCGEN */
